/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.adventure.spectator;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.k.a.sound.Sound;
import sba.k.a.t.BlockNBTComponent;
import sba.k.a.t.EntityNBTComponent;
import sba.k.a.t.KeybindComponent;
import sba.k.a.t.ScoreComponent;
import sba.k.a.t.SelectorComponent;
import sba.k.a.t.StorageNBTComponent;
import sba.k.a.t.TextComponent;
import sba.k.a.t.TranslatableComponent;
import sba.k.a.t.format.NamedTextColor;
import sba.k.a.t.format.TextColor;
import sba.k.a.t.serializer.ComponentSerializer;
import sba.k.a.t.serializer.gson.GsonComponentSerializer;
import sba.k.a.t.serializer.json.JSONComponentSerializer;
import sba.k.a.t.serializer.json.JSONOptions;
import sba.k.a.t.serializer.legacy.LegacyComponentSerializer;
import sba.k.a.t.serializer.plain.PlainComponentSerializer;
import sba.k.a.t.serializer.plain.PlainTextComponentSerializer;
import sba.sl.impl.adventure.spectator.AdventureBlockNBTComponent;
import sba.sl.impl.adventure.spectator.AdventureBook;
import sba.sl.impl.adventure.spectator.AdventureColor;
import sba.sl.impl.adventure.spectator.AdventureComponent;
import sba.sl.impl.adventure.spectator.AdventureEntityNBTComponent;
import sba.sl.impl.adventure.spectator.AdventureFeature;
import sba.sl.impl.adventure.spectator.AdventureKeybindComponent;
import sba.sl.impl.adventure.spectator.AdventureScoreComponent;
import sba.sl.impl.adventure.spectator.AdventureSelectorComponent;
import sba.sl.impl.adventure.spectator.AdventureShadowColor;
import sba.sl.impl.adventure.spectator.AdventureStorageNBTComponent;
import sba.sl.impl.adventure.spectator.AdventureTextComponent;
import sba.sl.impl.adventure.spectator.AdventureTranslatableComponent;
import sba.sl.impl.adventure.spectator.bossbar.AdventureBossBar;
import sba.sl.impl.adventure.spectator.event.AdventureClickEvent;
import sba.sl.impl.adventure.spectator.event.AdventureHoverEvent;
import sba.sl.impl.adventure.spectator.event.hover.AdventureEntityContent;
import sba.sl.impl.adventure.spectator.event.hover.AdventureItemContent;
import sba.sl.impl.adventure.spectator.sound.AdventureSoundSource;
import sba.sl.impl.adventure.spectator.sound.AdventureSoundStart;
import sba.sl.impl.adventure.spectator.sound.AdventureSoundStop;
import sba.sl.impl.adventure.spectator.title.AdventureTitle;
import sba.sl.impl.spectator.DummyShadowColor;
import sba.sl.impl.spectator.SpectatorBackend;
import sba.sl.nbt.SNBTSerializer;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.spectator.ShadowColor;
import sba.sl.spectator.sound.SoundSource;
import sba.sl.u.BidirectionalConverter;
import sba.sl.u.reflect.Reflect;

public class AdventureBackend
implements SpectatorBackend {
    @NotNull
    private static final BidirectionalConverter<AdventureComponent> additionalComponentConverter;
    @NotNull
    private static final BidirectionalConverter<AdventureClickEvent> additionalClickEventConverter;
    @NotNull
    private static final BidirectionalConverter<AdventureHoverEvent> additionalHoverEventConverter;
    @NotNull
    private static final BidirectionalConverter<AdventureEntityContent> additionalEntityContentConverter;
    @NotNull
    private static final BidirectionalConverter<AdventureItemContent> additionalItemContentConverter;
    @NotNull
    private static final BidirectionalConverter<AdventureColor> additionalColorConverter;
    @NotNull
    private static final BidirectionalConverter<AdventureShadowColor> additionalShadowColorConverter;
    @NotNull
    private static final LegacyComponentSerializer legacyComponentSerializer;
    @NotNull
    private static final ComponentSerializer<sba.k.a.t.Component, sba.k.a.t.Component, String> jsonComponentSerializer;
    @NotNull
    private static final ComponentSerializer<sba.k.a.t.Component, sba.k.a.t.Component, String> jsonComponentSerializerNonCompact;
    @NotNull
    private static final ComponentSerializer<sba.k.a.t.Component, TextComponent, String> plainTextComponentSerializer;
    @NotNull
    private static final Component empty;
    @NotNull
    private static final Component newLine;
    @NotNull
    private static final Component space;
    @NotNull
    protected static SNBTSerializer snbtSerializer;
    @NotNull
    protected static Function<String, String> soundKeyNormalizer;

    @Override
    @NotNull
    public Component empty() {
        return empty;
    }

    @Override
    @NotNull
    public Component newLine() {
        return newLine;
    }

    @Override
    @NotNull
    public Component space() {
        return space;
    }

    @Override
    @NotNull
    public Component fromLegacy(@NotNull String legacy) {
        return legacy.isEmpty() ? empty : AdventureBackend.wrapComponent(legacyComponentSerializer.deserialize(legacy));
    }

    @Override
    @NotNull
    public Component fromLegacy(@NotNull String legacy, char colorCharacter) {
        if (legacy.isEmpty()) {
            return empty;
        }
        if (colorCharacter == '\u00a7') {
            return this.fromLegacy(legacy);
        }
        return new AdventureComponent(LegacyComponentSerializer.builder().useUnusualXRepeatedCharacterHexFormat().character(colorCharacter).build().deserialize(legacy));
    }

    @Override
    @NotNull
    public Component fromJson(@NotNull String json) {
        if (json.isEmpty()) {
            return empty;
        }
        return new AdventureComponent(jsonComponentSerializer.deserialize(json));
    }

    @Override
    public  @NotNull BlockNBTComponent.Builder blockNBT() {
        return new AdventureBlockNBTComponent.AdventureBlockNBTBuilder(sba.k.a.t.Component.blockNBT());
    }

    @Override
    public  @NotNull EntityNBTComponent.Builder entityNBT() {
        return new AdventureEntityNBTComponent.AdventureEntityNBTBuilder(sba.k.a.t.Component.entityNBT());
    }

    @Override
    public  @NotNull KeybindComponent.Builder keybind() {
        return new AdventureKeybindComponent.AdventureKeybindBuilder(sba.k.a.t.Component.keybind());
    }

    @Override
    public  @NotNull ScoreComponent.Builder score() {
        return new AdventureScoreComponent.AdventureScoreBuilder(sba.k.a.t.Component.score());
    }

    @Override
    public  @NotNull SelectorComponent.Builder selector() {
        return new AdventureSelectorComponent.AdventureSelectorBuilder(sba.k.a.t.Component.selector());
    }

    @Override
    public  @NotNull StorageNBTComponent.Builder storageNBT() {
        return new AdventureStorageNBTComponent.AdventureStorageNBTBuilder(sba.k.a.t.Component.storageNBT());
    }

    @Override
    public  @NotNull TextComponent.Builder text() {
        return new AdventureTextComponent.AdventureTextBuilder(sba.k.a.t.Component.text());
    }

    @Override
    public  @NotNull TranslatableComponent.Builder translatable() {
        return new AdventureTranslatableComponent.AdventureTranslatableBuilder(sba.k.a.t.Component.translatable());
    }

    @Override
    @NotNull
    public Color rgb(int red, int green, int blue) {
        return new AdventureColor(TextColor.color(red, green, blue));
    }

    @Override
    @Nullable
    public Color named(@NotNull String name) {
        if ("grey".equalsIgnoreCase(name)) {
            name = "gray";
        } else if ("dark_grey".equalsIgnoreCase(name)) {
            name = "dark_gray";
        }
        NamedTextColor value = NamedTextColor.NAMES.value(name.toLowerCase(Locale.ROOT));
        if (value != null) {
            return new AdventureColor(value);
        }
        return null;
    }

    @Override
    @NotNull
    public Color hexOrName(@NotNull String hexName) {
        TextColor hex;
        NamedTextColor value = NamedTextColor.NAMES.value(((String)hexName).toLowerCase(Locale.ROOT));
        if (value != null) {
            return new AdventureColor(value);
        }
        if (!((String)hexName).startsWith("#")) {
            hexName = "#" + (String)hexName;
        }
        return new AdventureColor((hex = TextColor.fromCSSHexString((String)hexName)) != null ? hex : NamedTextColor.WHITE);
    }

    @Override
    @NotNull
    public Color nearestNamedTo(@Nullable Color color) {
        return new AdventureColor(NamedTextColor.nearestTo(color != null ? color.as(TextColor.class) : NamedTextColor.WHITE));
    }

    @Override
    public  @NotNull BossBar.Builder bossBar() {
        return new AdventureBossBar.AdventureBossBarBuilder();
    }

    @Override
    public  @NotNull SoundStart.Builder soundStart() {
        return new AdventureSoundStart.AdventureSoundStartBuilder();
    }

    @Override
    public  @NotNull SoundStop.Builder soundStop() {
        return new AdventureSoundStop.AdventureSoundStopBuilder();
    }

    @Override
    @NotNull
    public SoundSource soundSource(@NotNull String source) {
        Sound.Source soundSource = Sound.Source.NAMES.value(source);
        return new AdventureSoundSource(Objects.requireNonNullElse(soundSource, Sound.Source.MASTER));
    }

    @Override
    public  @NotNull Title.Builder title() {
        return new AdventureTitle.AdventureTitleBuilder();
    }

    @Override
    public  @NotNull Book.Builder book() {
        return new AdventureBook.AdventureBookBuilder();
    }

    @Override
    public  @NotNull ClickEvent.Builder clickEvent() {
        return new AdventureClickEvent.AdventureClickEventBuilder();
    }

    @Override
    public  @NotNull HoverEvent.Builder hoverEvent() {
        return new AdventureHoverEvent.AdventureHoverEventBuilder();
    }

    @Override
    public  @NotNull EntityContent.Builder entityContent() {
        return new AdventureEntityContent.AdventureEntityContentBuilder();
    }

    @Override
    public  @NotNull ItemContent.Builder itemContent() {
        return new AdventureItemContent.AdventureItemContentBuilder();
    }

    @Override
    @Nullable
    public Component fromPlatform(@NotNull Object platformObject) {
        if (platformObject instanceof Component) {
            return (Component)platformObject;
        }
        if (platformObject instanceof sba.k.a.t.Component) {
            return AdventureBackend.wrapComponent((sba.k.a.t.Component)platformObject);
        }
        throw new IllegalArgumentException("Not possible to convert unknown object type to Component: " + String.valueOf(platformObject));
    }

    @Override
    @NotNull
    public ShadowColor shadowArgb(int alpha, int red, int green, int blue) {
        if (!AdventureFeature.SHADOW_COLOR.isSupported()) {
            return new DummyShadowColor(red, green, blue, alpha);
        }
        return new AdventureShadowColor(sba.k.a.t.format.ShadowColor.shadowColor((int)red, (int)green, (int)blue, (int)alpha));
    }

    @Override
    @NotNull
    public ShadowColor shadowHex(@NotNull String hexOrName) {
        if (!hexOrName.startsWith("#") && hexOrName.length() == 8 || hexOrName.startsWith("#") && hexOrName.length() == 9) {
            Object hex = !hexOrName.startsWith("#") ? "#" + hexOrName : hexOrName;
            try {
                int r = Integer.parseInt(((String)hex).substring(1, 3), 16);
                int g = Integer.parseInt(((String)hex).substring(3, 5), 16);
                int b = Integer.parseInt(((String)hex).substring(5, 7), 16);
                int a = Integer.parseInt(((String)hex).substring(7, 9), 16);
                if (!AdventureFeature.SHADOW_COLOR.isSupported()) {
                    return new DummyShadowColor(r, g, b, a);
                }
                return new AdventureShadowColor(sba.k.a.t.format.ShadowColor.shadowColor((int)r, (int)g, (int)b, (int)a));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.hexOrName(hexOrName).asShadow();
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static Component wrapComponent(@Nullable sba.k.a.t.Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof StorageNBTComponent) {
            return new AdventureStorageNBTComponent((StorageNBTComponent)component);
        }
        if (component instanceof EntityNBTComponent) {
            return new AdventureEntityNBTComponent((EntityNBTComponent)component);
        }
        if (component instanceof BlockNBTComponent) {
            return new AdventureBlockNBTComponent((BlockNBTComponent)component);
        }
        if (component instanceof TranslatableComponent) {
            return new AdventureTranslatableComponent((TranslatableComponent)component);
        }
        if (component instanceof SelectorComponent) {
            return new AdventureSelectorComponent((SelectorComponent)component);
        }
        if (component instanceof ScoreComponent) {
            return new AdventureScoreComponent((ScoreComponent)component);
        }
        if (component instanceof KeybindComponent) {
            return new AdventureKeybindComponent((KeybindComponent)component);
        }
        if (component instanceof TextComponent) {
            return new AdventureTextComponent((TextComponent)component);
        }
        return new AdventureComponent(component);
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<AdventureComponent> getAdditionalComponentConverter() {
        return additionalComponentConverter;
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<AdventureClickEvent> getAdditionalClickEventConverter() {
        return additionalClickEventConverter;
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<AdventureHoverEvent> getAdditionalHoverEventConverter() {
        return additionalHoverEventConverter;
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<AdventureEntityContent> getAdditionalEntityContentConverter() {
        return additionalEntityContentConverter;
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<AdventureItemContent> getAdditionalItemContentConverter() {
        return additionalItemContentConverter;
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<AdventureColor> getAdditionalColorConverter() {
        return additionalColorConverter;
    }

    @NotNull
    @Generated
    public static BidirectionalConverter<AdventureShadowColor> getAdditionalShadowColorConverter() {
        return additionalShadowColorConverter;
    }

    @NotNull
    @Generated
    public static LegacyComponentSerializer getLegacyComponentSerializer() {
        return legacyComponentSerializer;
    }

    @NotNull
    @Generated
    public static ComponentSerializer<sba.k.a.t.Component, sba.k.a.t.Component, String> getJsonComponentSerializer() {
        return jsonComponentSerializer;
    }

    @NotNull
    @Generated
    public static ComponentSerializer<sba.k.a.t.Component, sba.k.a.t.Component, String> getJsonComponentSerializerNonCompact() {
        return jsonComponentSerializerNonCompact;
    }

    @NotNull
    @Generated
    public static ComponentSerializer<sba.k.a.t.Component, TextComponent, String> getPlainTextComponentSerializer() {
        return plainTextComponentSerializer;
    }

    @NotNull
    @Generated
    public static Component getEmpty() {
        return empty;
    }

    @NotNull
    @Generated
    public static Component getNewLine() {
        return newLine;
    }

    @NotNull
    @Generated
    public static Component getSpace() {
        return space;
    }

    @NotNull
    @Generated
    public static SNBTSerializer getSnbtSerializer() {
        return snbtSerializer;
    }

    @NotNull
    @Generated
    public static Function<String, String> getSoundKeyNormalizer() {
        return soundKeyNormalizer;
    }

    static {
        Object jsonComponentNonCompact;
        Object jsonComponent;
        additionalComponentConverter = BidirectionalConverter.build();
        additionalClickEventConverter = BidirectionalConverter.build();
        additionalHoverEventConverter = BidirectionalConverter.build();
        additionalEntityContentConverter = BidirectionalConverter.build();
        additionalItemContentConverter = BidirectionalConverter.build();
        additionalColorConverter = BidirectionalConverter.build();
        additionalShadowColorConverter = BidirectionalConverter.build();
        legacyComponentSerializer = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().character('\u00a7').build();
        empty = AdventureBackend.wrapComponent(sba.k.a.t.Component.empty());
        newLine = AdventureBackend.wrapComponent(sba.k.a.t.Component.newline());
        space = AdventureBackend.wrapComponent(sba.k.a.t.Component.space());
        snbtSerializer = SNBTSerializer.builder().shouldSaveLongArraysDirectly(false).build();
        soundKeyNormalizer = s -> s;
        Object plainText = AdventureFeature.PLAIN_TEXT_COMPONENT_SERIALIZER.isSupported() ? PlainTextComponentSerializer.plainText() : PlainComponentSerializer.plain();
        plainTextComponentSerializer = plainText;
        if (AdventureFeature.JSON_COMPONENT_SERIALIZER.isSupported()) {
            jsonComponent = JSONComponentSerializer.json();
            if ("sba.k.a.t.serializer.json.DummyJSONComponentSerializer".equals(jsonComponent.getClass().getName()) && Reflect.has("sba.k.a.t.serializer.gson.GsonComponentSerializer")) {
                jsonComponent = GsonComponentSerializer.gson();
                jsonComponentNonCompact = AdventureFeature.JSON_OPTIONS.isSupported() ? ((GsonComponentSerializer.Builder)((GsonComponentSerializer)jsonComponent).toBuilder()).editOptions(state -> state.value(JSONOptions.EMIT_COMPACT_TEXT_COMPONENT, (Object)false)).build() : jsonComponent;
            } else {
                jsonComponentNonCompact = AdventureFeature.JSON_OPTIONS.isSupported() ? JSONComponentSerializer.builder().editOptions(state -> state.value(JSONOptions.EMIT_COMPACT_TEXT_COMPONENT, (Object)false)).build() : jsonComponent;
            }
        } else {
            jsonComponentNonCompact = jsonComponent = GsonComponentSerializer.gson();
        }
        jsonComponentSerializer = jsonComponent;
        jsonComponentSerializerNonCompact = jsonComponentNonCompact;
    }
}

