/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.adventure.spectator.event.click;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.k.a.dialog.DialogLike;
import sba.k.a.key.Key;
import sba.k.a.nbt.api.BinaryTagHolder;
import sba.k.a.t.event.ClickEvent;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.adventure.spectator.event.click.AdventurePayloadCustom;
import sba.sl.impl.adventure.spectator.event.click.AdventurePayloadShowDialog;
import sba.sl.nbt.Tag;
import sba.sl.spectator.event.click.Payload;
import sba.sl.u.ResourceLocation;

public final class PayloadConverter {
    @NotNull
    public static Payload convertPayload(@NotNull ClickEvent clickEvent) {
        ClickEvent.Payload payload = clickEvent.payload();
        if (payload instanceof ClickEvent.Payload.Text) {
            return Payload.text(((ClickEvent.Payload.Text)payload).value());
        }
        if (payload instanceof ClickEvent.Payload.Int) {
            return Payload.integer(((ClickEvent.Payload.Int)payload).integer());
        }
        if (payload instanceof ClickEvent.Payload.Custom) {
            return new AdventurePayloadCustom((ClickEvent.Payload.Custom)payload);
        }
        if (payload instanceof ClickEvent.Payload.Dialog) {
            return new AdventurePayloadShowDialog((ClickEvent.Payload.Dialog)payload);
        }
        throw new UnsupportedOperationException("Unknown payload of class " + String.valueOf(payload.getClass()));
    }

    @NotNull
    public static ClickEvent withPayload(@NotNull ClickEvent.Action action, @NotNull Payload payload) {
        switch (action) {
            case OPEN_URL: {
                if (!(payload instanceof Payload.Text)) break;
                return ClickEvent.openUrl(((Payload.Text)payload).text());
            }
            case OPEN_FILE: {
                if (!(payload instanceof Payload.Text)) break;
                return ClickEvent.openFile(((Payload.Text)payload).text());
            }
            case RUN_COMMAND: {
                if (!(payload instanceof Payload.Text)) break;
                return ClickEvent.runCommand(((Payload.Text)payload).text());
            }
            case SUGGEST_COMMAND: {
                if (!(payload instanceof Payload.Text)) break;
                return ClickEvent.suggestCommand(((Payload.Text)payload).text());
            }
            case CHANGE_PAGE: {
                if (payload instanceof Payload.Text) {
                    return ClickEvent.changePage(Integer.parseInt(((Payload.Text)payload).text()));
                }
                if (!(payload instanceof Payload.Int)) break;
                return ClickEvent.changePage(((Payload.Int)payload).number());
            }
            case COPY_TO_CLIPBOARD: {
                if (!(payload instanceof Payload.Text)) break;
                return ClickEvent.copyToClipboard(((Payload.Text)payload).text());
            }
            case SHOW_DIALOG: {
                if (payload instanceof AdventurePayloadShowDialog) {
                    return ClickEvent.showDialog((DialogLike)((AdventurePayloadShowDialog)payload).as(ClickEvent.Payload.Dialog.class).dialog());
                }
                if (!(payload instanceof Payload.ShowDialog)) break;
                return ClickEvent.showDialog((DialogLike)((Payload.ShowDialog)payload).dialog().as(DialogLike.class));
            }
            case CUSTOM: {
                if (payload instanceof AdventurePayloadCustom) {
                    ClickEvent.Payload.Custom advPayload = ((AdventurePayloadCustom)payload).as(ClickEvent.Payload.Custom.class);
                    return ClickEvent.custom((Key)advPayload.key(), (BinaryTagHolder)advPayload.nbt());
                }
                if (!(payload instanceof Payload.Custom)) break;
                ResourceLocation location = ((Payload.Custom)payload).location();
                Tag tag = ((Payload.Custom)payload).tag();
                return ClickEvent.custom((Key)Key.key(location.namespace(), location.path()), (BinaryTagHolder)BinaryTagHolder.binaryTagHolder(AdventureBackend.getSnbtSerializer().serialize(tag)));
            }
        }
        throw new IllegalArgumentException("Cannot use payload type " + String.valueOf(payload.getClass()) + " for action " + action.name());
    }

    @NotNull
    public static ClickEvent withAction(@NotNull ClickEvent.Action action, @NotNull ClickEvent clickEvent) {
        ClickEvent.Payload payload = clickEvent.payload();
        switch (action) {
            case OPEN_URL: {
                if (!(payload instanceof ClickEvent.Payload.Text)) break;
                return ClickEvent.openUrl(((ClickEvent.Payload.Text)payload).value());
            }
            case OPEN_FILE: {
                if (!(payload instanceof ClickEvent.Payload.Text)) break;
                return ClickEvent.openFile(((ClickEvent.Payload.Text)payload).value());
            }
            case RUN_COMMAND: {
                if (!(payload instanceof ClickEvent.Payload.Text)) break;
                return ClickEvent.runCommand(((ClickEvent.Payload.Text)payload).value());
            }
            case SUGGEST_COMMAND: {
                if (!(payload instanceof ClickEvent.Payload.Text)) break;
                return ClickEvent.suggestCommand(((ClickEvent.Payload.Text)payload).value());
            }
            case CHANGE_PAGE: {
                if (payload instanceof ClickEvent.Payload.Text) {
                    return ClickEvent.changePage(Integer.parseInt(((ClickEvent.Payload.Text)payload).value()));
                }
                if (!(payload instanceof ClickEvent.Payload.Int)) break;
                return ClickEvent.changePage(((ClickEvent.Payload.Int)payload).integer());
            }
            case COPY_TO_CLIPBOARD: {
                if (!(payload instanceof ClickEvent.Payload.Text)) break;
                return ClickEvent.copyToClipboard(((ClickEvent.Payload.Text)payload).value());
            }
            case SHOW_DIALOG: {
                if (!(payload instanceof ClickEvent.Payload.Dialog)) break;
                return ClickEvent.showDialog((DialogLike)((ClickEvent.Payload.Dialog)payload).dialog());
            }
            case CUSTOM: {
                if (!(payload instanceof ClickEvent.Payload.Custom)) break;
                return ClickEvent.custom((Key)((ClickEvent.Payload.Custom)payload).key(), (BinaryTagHolder)((ClickEvent.Payload.Custom)payload).nbt());
            }
        }
        throw new IllegalArgumentException("Cannot use action " + action.name() + " with payload type " + String.valueOf(payload.getClass()));
    }

    @Generated
    private PayloadConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

