/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit;

import java.util.Collection;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListenerRegistration;
import org.jetbrains.annotations.NotNull;
import sba.sl.CustomPayload;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.u.BasicWrapper;
import sba.sl.u.annotations.Service;

@Service
public class BukkitCustomPayload
extends CustomPayload {
    @NotNull
    private final Plugin plugin;

    @Override
    protected void registerOutgoingChannel0(@NotNull String channel) {
        Bukkit.getMessenger().registerOutgoingPluginChannel(this.plugin, channel);
    }

    @Override
    protected void unregisterOutgoingChannel0(@NotNull String channel) {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel(this.plugin, channel);
    }

    @Override
    protected void unregisterAllOutgoingChannels0() {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel(this.plugin);
    }

    @Override
    @NotNull
    protected @NotNull Collection<@NotNull String> getRegisteredOutgoingChannels0() {
        return Bukkit.getMessenger().getOutgoingChannels(this.plugin);
    }

    @Override
    @NotNull
    protected CustomPayload.Registration registerIncomingChannel0(@NotNull String channel, @NotNull @NotNull BiConsumer<@NotNull sba.sl.pa.Player, byte @NotNull []> listener) {
        return new BukkitRegistration(Bukkit.getMessenger().registerIncomingPluginChannel(this.plugin, channel, (channel1, player, message) -> {
            if (channel1.equals(channel)) {
                listener.accept(new BukkitPlayer(player), message);
            }
        }));
    }

    @Override
    protected void unregisterIncomingChannel0(@NotNull CustomPayload.Registration registration) {
        if (!(registration instanceof BukkitRegistration)) {
            throw new UnsupportedOperationException("Registration is not instance of BukkitRegistration class!");
        }
        PluginMessageListenerRegistration bRegistration = registration.as(PluginMessageListenerRegistration.class);
        Bukkit.getMessenger().unregisterIncomingPluginChannel(bRegistration.getPlugin(), bRegistration.getChannel(), bRegistration.getListener());
    }

    @Override
    protected void unregisterAllIncomingChannels0() {
        Bukkit.getMessenger().unregisterIncomingPluginChannel(this.plugin);
    }

    @Override
    @NotNull
    protected @NotNull Collection<@NotNull String> getRegisteredIncomingChannels0() {
        return Bukkit.getMessenger().getIncomingChannels(this.plugin);
    }

    @Override
    protected void send0(sba.sl.pa.Player player, @NotNull String channel, byte @NotNull [] payload) {
        player.as(Player.class).sendPluginMessage(this.plugin, channel, payload);
    }

    @Override
    protected void send0(@NotNull String channel, byte @NotNull [] payload) {
        Bukkit.getServer().sendPluginMessage(this.plugin, channel, payload);
    }

    @Generated
    public BukkitCustomPayload(@NotNull Plugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }

    public static class BukkitRegistration
    extends BasicWrapper<PluginMessageListenerRegistration>
    implements CustomPayload.Registration {
        protected BukkitRegistration(@NotNull PluginMessageListenerRegistration wrappedObject) {
            super(wrappedObject);
        }
    }
}

