/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.DyeColor;
import sba.sl.impl.DyeColorRegistry;
import sba.sl.impl.bukkit.BukkitDyeColor;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.Service;
import sba.sl.u.registry.RegistryItemStream;

@Service
public class BukkitDyeColorRegistry
extends DyeColorRegistry {
    public BukkitDyeColorRegistry() {
        this.specialType(org.bukkit.DyeColor.class, BukkitDyeColor::new);
    }

    @Override
    @Nullable
    protected DyeColor resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        try {
            String path = location.path();
            if (!BukkitFeature.DYE_COLOR_LIGHT_GRAY_SUPPORTED.isSupported() && "light_gray".equals(path)) {
                path = "silver";
            }
            org.bukkit.DyeColor value = org.bukkit.DyeColor.valueOf((String)path.toUpperCase(Locale.ROOT));
            return new BukkitDyeColor(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull DyeColor> getRegistryItemStream0() {
        if (BukkitFeature.DYE_COLOR_LIGHT_GRAY_SUPPORTED.isSupported()) {
            return new SimpleRegistryItemStream<org.bukkit.DyeColor, DyeColor>(() -> Arrays.stream(org.bukkit.DyeColor.values()), BukkitDyeColor::new, dyeColor -> ResourceLocation.of(dyeColor.name()), (dyeColor, literal) -> dyeColor.name().toLowerCase(Locale.ROOT).contains((CharSequence)literal), (dyeColor, namespace) -> "minecraft".equals(namespace), List.of());
        }
        return new SimpleRegistryItemStream<org.bukkit.DyeColor, DyeColor>(() -> Arrays.stream(org.bukkit.DyeColor.values()), BukkitDyeColor::new, dyeColor -> {
            if ("SILVER".equals(dyeColor.name())) {
                return ResourceLocation.of("light_gray");
            }
            return ResourceLocation.of(dyeColor.name());
        }, (dyeColor, literal) -> {
            String path = dyeColor.name().toLowerCase(Locale.ROOT);
            if ("silver".equals(path)) {
                path = "light_gray";
            }
            return path.contains((CharSequence)literal);
        }, (dyeColor, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

