/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.container;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.cn.Container;
import sba.sl.cn.type.InventoryType;
import sba.sl.i.ItemStack;
import sba.sl.i.ItemType;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.item.BukkitItem;
import sba.sl.u.BasicWrapper;

public class BukkitContainer
extends BasicWrapper<Inventory>
implements Container {
    public BukkitContainer(@NotNull Inventory wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @Nullable
    public ItemStack getItem(int index) {
        org.bukkit.inventory.ItemStack item = ((Inventory)this.wrappedObject).getItem(index);
        return item == null ? null : new BukkitItem(item);
    }

    @Override
    public void setItem(int index, @Nullable ItemStack item) {
        ((Inventory)this.wrappedObject).setItem(index, item != null ? item.as(org.bukkit.inventory.ItemStack.class) : null);
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull ItemStack> addItem(ItemStack ... items) {
        return ((Inventory)this.wrappedObject).addItem((org.bukkit.inventory.ItemStack[])Arrays.stream(items).map(item -> item.as(org.bukkit.inventory.ItemStack.class)).toArray(org.bukkit.inventory.ItemStack[]::new)).values().stream().filter(Objects::nonNull).map(BukkitItem::new).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull ItemStack> removeItem(ItemStack ... items) {
        return ((Inventory)this.wrappedObject).removeItem((org.bukkit.inventory.ItemStack[])Arrays.stream(items).map(item -> item.as(org.bukkit.inventory.ItemStack.class)).toArray(org.bukkit.inventory.ItemStack[]::new)).values().stream().filter(Objects::nonNull).map(BukkitItem::new).collect(Collectors.toList());
    }

    @Override
    public @Nullable ItemStack @NotNull [] getContents() {
        org.bukkit.inventory.ItemStack[] oldArray;
        ItemStack[] array = new ItemStack[this.getSize()];
        if (!BukkitFeature.GET_STORAGE_CONTENTS.isSupported() && this.wrappedObject instanceof PlayerInventory) {
            oldArray = new org.bukkit.inventory.ItemStack[40];
            System.arraycopy(((Inventory)this.wrappedObject).getContents(), 0, oldArray, 0, 36);
            System.arraycopy(((PlayerInventory)this.wrappedObject).getArmorContents(), 0, oldArray, 36, 4);
        } else {
            oldArray = ((Inventory)this.wrappedObject).getContents();
        }
        for (int i = 0; i < this.getSize(); ++i) {
            array[i] = oldArray[i] == null ? null : new BukkitItem(oldArray[i]);
        }
        return array;
    }

    @Override
    public @Nullable ItemStack @NotNull [] getStorageContents() {
        @Nullable org.bukkit.inventory.ItemStack @NotNull [] oldArray = BukkitFeature.GET_STORAGE_CONTENTS.isSupported() ? ((Inventory)this.wrappedObject).getStorageContents() : ((Inventory)this.wrappedObject).getContents();
        ItemStack[] array = new ItemStack[oldArray.length];
        for (int i = 0; i < oldArray.length; ++i) {
            array[i] = oldArray[i] == null ? null : new BukkitItem(oldArray[i]);
        }
        return array;
    }

    @Override
    public void setContents(@Nullable ItemStack @NotNull [] items) throws IllegalArgumentException {
        if (items.length > this.getSize()) {
            throw new IllegalArgumentException("Wrong size of items array. Must be " + this.getSize() + " or less");
        }
        org.bukkit.inventory.ItemStack[] array = new org.bukkit.inventory.ItemStack[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            array[i] = items[i] != null ? items[i].as(org.bukkit.inventory.ItemStack.class) : null;
        }
        ((Inventory)this.wrappedObject).setContents(array);
    }

    @Override
    public void setStorageContents(@Nullable ItemStack @NotNull [] items) throws IllegalArgumentException {
        if (items.length > this.getSize()) {
            throw new IllegalArgumentException("Wrong size of items array. Must be " + this.getSize() + " or less");
        }
        if (BukkitFeature.GET_STORAGE_CONTENTS.isSupported()) {
            org.bukkit.inventory.ItemStack[] array = new org.bukkit.inventory.ItemStack[items.length];
            for (int i = 0; i < array.length; ++i) {
                array[i] = items[i] != null ? items[i].as(org.bukkit.inventory.ItemStack.class) : null;
            }
            ((Inventory)this.wrappedObject).setStorageContents(array);
        } else {
            this.setContents(items);
        }
    }

    @Override
    public boolean contains(@NotNull ItemType materialHolder) {
        return ((Inventory)this.wrappedObject).contains(materialHolder.as(Material.class));
    }

    @Override
    public boolean contains(@NotNull ItemStack item) {
        return ((Inventory)this.wrappedObject).contains(item.as(org.bukkit.inventory.ItemStack.class));
    }

    @Override
    public boolean containsAtLeast(@NotNull ItemStack item, int amount) {
        return ((Inventory)this.wrappedObject).containsAtLeast(item.as(org.bukkit.inventory.ItemStack.class), amount);
    }

    @Override
    public int getSize() {
        return ((Inventory)this.wrappedObject).getSize();
    }

    @Override
    public boolean isEmpty() {
        return ((Inventory)this.wrappedObject).isEmpty();
    }

    @Override
    @NotNull
    public InventoryType getType() {
        return InventoryType.of(((Inventory)this.wrappedObject).getType());
    }

    @Override
    public void clear() {
        ((Inventory)this.wrappedObject).clear();
    }

    @Override
    public int firstEmptySlot() {
        return ((Inventory)this.wrappedObject).firstEmpty();
    }

    @Override
    public void openInventory(@NotNull sba.sl.pa.Player wrapper) {
        wrapper.asOptional(Player.class).ifPresent(player -> player.openInventory((Inventory)this.wrappedObject));
    }
}

