/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.entity.type;

import java.util.Arrays;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.type.EntityType;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.entity.type.BukkitEntityTypeRegistry;
import sba.sl.impl.bukkit.entity.type.InternalEntityLegacyConstants;
import sba.sl.impl.bukkit.tags.KeyedUtils;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;
import sba.sl.u.reflect.Reflect;

public class BukkitEntityType1_11
extends BasicWrapper<org.bukkit.entity.EntityType>
implements EntityType {
    public BukkitEntityType1_11(@NotNull org.bukkit.entity.EntityType wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public String platformName() {
        return ((org.bukkit.entity.EntityType)this.wrappedObject).name();
    }

    @Override
    public boolean isAlive() {
        return ((org.bukkit.entity.EntityType)this.wrappedObject).isAlive();
    }

    @Override
    public boolean hasTag(@NotNull Object tag) {
        ResourceLocation key = tag instanceof ResourceLocation ? (ResourceLocation)tag : ResourceLocation.of(tag.toString());
        if (BukkitFeature.TAGS.isSupported()) {
            if (BukkitFeature.REGISTRY_ENTITY_TYPES.isSupported()) {
                KeyedUtils.isTagged("entity_types", new NamespacedKey(key.namespace(), key.path()), org.bukkit.entity.EntityType.class, (org.bukkit.entity.EntityType)this.wrappedObject);
            } else if (BukkitFeature.REGISTRY_ENTITIES.isSupported()) {
                KeyedUtils.isTagged((String)Reflect.getField(Tag.class, "REGISTRY_ENTITIES"), new NamespacedKey(key.namespace(), key.path()), org.bukkit.entity.EntityType.class, (org.bukkit.entity.EntityType)this.wrappedObject);
            }
        }
        if (!"minecraft".equals(key.namespace())) {
            return false;
        }
        String value = key.path();
        return BukkitEntityTypeRegistry.hasTagInBackPorts((org.bukkit.entity.EntityType)this.wrappedObject, value);
    }

    @Override
    public boolean is(@Nullable Object entityType) {
        String str;
        if (entityType instanceof org.bukkit.entity.EntityType || entityType instanceof EntityType) {
            return this.equals(entityType);
        }
        if (entityType instanceof String && (str = (String)entityType).startsWith("#")) {
            return this.hasTag(str.substring(1));
        }
        return this.equals(EntityType.ofNullable(entityType));
    }

    @Override
    public boolean is(Object ... entityTypes) {
        return Arrays.stream(entityTypes).anyMatch(this::is);
    }

    @Override
    @NotNull
    public ResourceLocation location() {
        if (BukkitFeature.ENTITY_KEYED.isSupported()) {
            NamespacedKey namespaced = ((org.bukkit.entity.EntityType)this.wrappedObject).getKey();
            return ResourceLocation.of(namespaced.getNamespace(), namespaced.getKey());
        }
        return InternalEntityLegacyConstants.translateLegacyName1_11((org.bukkit.entity.EntityType)this.wrappedObject);
    }
}

