/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.player;

import java.util.Objects;
import lombok.Generated;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.pa.Player;
import sba.sl.sl.EquipmentSlot;

public class BukkitPlayerInteractEntityEvent
implements sba.sl.ev.player.PlayerInteractEntityEvent,
BukkitCancellable {
    @NotNull
    private final PlayerInteractEntityEvent event;
    @Nullable
    private Player player;
    @Nullable
    private Entity clickedEntity;
    @Nullable
    private EquipmentSlot hand;

    @Override
    @NotNull
    public Player player() {
        if (this.player == null) {
            this.player = new BukkitPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @NotNull
    public Entity clickedEntity() {
        if (this.clickedEntity == null) {
            this.clickedEntity = Objects.requireNonNull(Entities.wrapEntity(this.event.getRightClicked()));
        }
        return this.clickedEntity;
    }

    @Override
    @NotNull
    public EquipmentSlot hand() {
        if (this.hand == null) {
            this.hand = BukkitFeature.OFF_HAND.isSupported() ? EquipmentSlot.of(this.event.getHand()) : EquipmentSlot.of("main_hand");
        }
        return this.hand;
    }

    @Generated
    public BukkitPlayerInteractEntityEvent(@NotNull PlayerInteractEntityEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitPlayerInteractEntityEvent)) {
            return false;
        }
        BukkitPlayerInteractEntityEvent other = (BukkitPlayerInteractEntityEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerInteractEntityEvent this$event = this.event();
        PlayerInteractEntityEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitPlayerInteractEntityEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerInteractEntityEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitPlayerInteractEntityEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public PlayerInteractEntityEvent event() {
        return this.event;
    }
}

