/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.player;

import java.util.Arrays;
import lombok.Generated;
import org.bukkit.event.block.SignChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import sba.sl.b.BlockPlacement;
import sba.sl.ev.player.PlayerUpdateSignEvent;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.pa.Player;
import sba.sl.spectator.Component;

public class BukkitPlayerUpdateSignEvent
implements PlayerUpdateSignEvent,
BukkitCancellable {
    @NotNull
    private final SignChangeEvent event;
    @Nullable
    private Player player;
    @Nullable
    private BlockPlacement block;

    @Override
    @NotNull
    public Player player() {
        if (this.player == null) {
            this.player = new BukkitPlayer(this.event.getPlayer());
        }
        return this.player;
    }

    @Override
    @NotNull
    public BlockPlacement block() {
        if (this.block == null) {
            this.block = new BukkitBlockPlacement(this.event.getBlock());
        }
        return this.block;
    }

    @Override
    @NotNull
    public @NotNull Component @NotNull [] lines() {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            return (Component[])this.event.lines().stream().map(AdventureBackend::wrapComponent).toArray(Component[]::new);
        }
        return (Component[])Arrays.stream(this.event.getLines()).map(Component::fromLegacy).toArray(Component[]::new);
    }

    @Override
    @NotNull
    public Component line(@Range(from=0L, to=3L) int index) {
        return this.lines()[index];
    }

    @Override
    public void line(@Range(from=0L, to=3L) int index, @NotNull Component component) {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            this.event.line(index, component.as(sba.k.a.t.Component.class));
        } else {
            this.event.setLine(index, component.toLegacy());
        }
    }

    @Generated
    public BukkitPlayerUpdateSignEvent(@NotNull SignChangeEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitPlayerUpdateSignEvent)) {
            return false;
        }
        BukkitPlayerUpdateSignEvent other = (BukkitPlayerUpdateSignEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SignChangeEvent this$event = this.event();
        SignChangeEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitPlayerUpdateSignEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SignChangeEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitPlayerUpdateSignEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public SignChangeEvent event() {
        return this.event;
    }
}

