/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.a.AttributeModifier;
import sba.sl.a.AttributeType;
import sba.sl.a.ItemAttribute;
import sba.sl.i.HideFlags;
import sba.sl.i.ItemStack;
import sba.sl.i.ItemStackView;
import sba.sl.i.ItemType;
import sba.sl.i.builder.ItemStackBuilder;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.i.data.ItemData;
import sba.sl.i.meta.Enchantment;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.attribute.Attributes;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.attribute.BukkitItemAttribute;
import sba.sl.impl.bukkit.item.BukkitItemType1_8;
import sba.sl.impl.bukkit.item.builder.BukkitItemBuilder;
import sba.sl.impl.bukkit.item.data.BukkitItemDataCustomTags;
import sba.sl.impl.bukkit.item.data.BukkitItemDataPersistentContainer;
import sba.sl.impl.bukkit.item.data.CraftBukkitItemData;
import sba.sl.impl.bukkit.utils.DataFixerUtils;
import sba.sl.impl.bukkit.utils.Version;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.nbt.CompoundTagAccessor;
import sba.sl.impl.nms.accessors.nbt.ListTagAccessor;
import sba.sl.impl.nms.accessors.server.MinecraftServerAccessor;
import sba.sl.impl.nms.accessors.world.item.ItemStackAccessor;
import sba.sl.impl.vanilla.nbt.NBTVanillaSerializer;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.NumericTag;
import sba.sl.nbt.StringTag;
import sba.sl.nbt.Tag;
import sba.sl.sl.EquipmentSlot;
import sba.sl.spectator.Component;
import sba.sl.u.BasicWrapper;
import sba.sl.u.StringUtils;
import sba.sl.u.reflect.Reflect;

public class BukkitItem
extends BasicWrapper<org.bukkit.inventory.ItemStack>
implements ItemStack {
    @Nullable
    private CompoundTag tagCache;

    public BukkitItem(@NotNull org.bukkit.inventory.ItemStack wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public ItemType getType() {
        if (BukkitFeature.FLATTENING.isSupported()) {
            return ItemType.of(((org.bukkit.inventory.ItemStack)this.wrappedObject).getType());
        }
        return new BukkitItemType1_8(((org.bukkit.inventory.ItemStack)this.wrappedObject).getType(), ((org.bukkit.inventory.ItemStack)this.wrappedObject).getType().getMaxDurability() > 0 ? (short)0 : ((org.bukkit.inventory.ItemStack)this.wrappedObject).getDurability());
    }

    @Override
    public int getAmount() {
        return ((org.bukkit.inventory.ItemStack)this.wrappedObject).getAmount();
    }

    @Override
    @Nullable
    public Component getDisplayName() {
        ItemMeta meta = ((org.bukkit.inventory.ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            if (BukkitCore.getSpectatorBackend().hasAdventure()) {
                return AdventureBackend.wrapComponent(meta.displayName());
            }
            return Component.fromLegacy(meta.getDisplayName());
        }
        return null;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Component> getLore() {
        ItemMeta meta = ((org.bukkit.inventory.ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null && meta.hasLore()) {
            if (BukkitCore.getSpectatorBackend().hasAdventure()) {
                return Objects.requireNonNullElseGet(meta.lore(), List::of).stream().map(AdventureBackend::wrapComponent).collect(Collectors.toUnmodifiableList());
            }
            return Objects.requireNonNullElseGet(meta.getLore(), List::of).stream().map(Component::fromLegacy).collect(Collectors.toUnmodifiableList());
        }
        return List.of();
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull ItemAttribute> getAttributeModifiers() {
        ItemMeta meta = ((org.bukkit.inventory.ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            if (BukkitFeature.ITEM_ATTRIBUTE_MODIFIERS_API.isSupported()) {
                Multimap bukkitModifiers = meta.getAttributeModifiers();
                if (bukkitModifiers != null && !bukkitModifiers.isEmpty()) {
                    ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>(bukkitModifiers.size());
                    bukkitModifiers.forEach((attribute, attributeModifier) -> {
                        ItemAttribute itemAttribute = Attributes.wrapItemAttribute(new BukkitItemAttribute((Attribute)attribute, (AttributeModifier)attributeModifier));
                        if (itemAttribute != null) {
                            list.add(itemAttribute);
                        }
                    });
                    return list;
                }
            } else {
                Object size;
                Object tag;
                if (!ClassStorage.CB.CraftItemStack.isInstance(this.wrappedObject)) {
                    Map unhandled = (Map)Reflect.getField((Object)meta, "unhandledTags");
                    if (!unhandled.containsKey("AttributeModifiers")) {
                        return List.of();
                    }
                    tag = unhandled.get("AttributeModifiers");
                } else {
                    Object nbt = Reflect.fastInvoke(ClassStorage.getHandleOfItemStack(this.wrappedObject), ItemStackAccessor.METHOD_GET_TAG.get());
                    tag = Reflect.fastInvoke(nbt, CompoundTagAccessor.METHOD_GET.get(), "AttributeModifiers");
                }
                if (tag != null && (size = Reflect.fastInvoke(tag, ListTagAccessor.METHOD_SIZE.get())) instanceof Integer) {
                    ArrayList<ItemAttribute> list = new ArrayList<ItemAttribute>((Integer)size);
                    for (int i = 0; i < (Integer)size; ++i) {
                        CompoundTag t = (CompoundTag)NBTVanillaSerializer.deserialize(Reflect.fastInvoke(tag, ListTagAccessor.METHOD_GET.get(), i));
                        list.add(new ItemAttribute(AttributeType.of(StringUtils.camelToSnake(((StringTag)t.tag("AttributeName")).value())), new UUID(((NumericTag)t.tag("UUIDMost")).longValue(), ((NumericTag)t.tag("UUIDLeast")).longValue()), ((StringTag)t.tag("Name")).value(), ((NumericTag)t.tag("Amount")).doubleValue(), AttributeModifier.Operation.byOrdinal(((NumericTag)t.tag("Operation")).intValue()), t.hasTag("Slot") ? EquipmentSlot.of(((StringTag)t.tag("Slot")).value()) : null));
                    }
                    return list;
                }
            }
        }
        return List.of();
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Enchantment> getEnchantments() {
        ItemMeta meta = ((org.bukkit.inventory.ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            ArrayList<Enchantment> list = new ArrayList<Enchantment>();
            if (meta instanceof EnchantmentStorageMeta) {
                ((EnchantmentStorageMeta)meta).getStoredEnchants().entrySet().forEach(entry -> {
                    Enchantment enchantment = Enchantment.ofNullable(entry);
                    if (enchantment != null) {
                        list.add(enchantment);
                    }
                });
            } else {
                meta.getEnchants().entrySet().forEach(entry -> {
                    Enchantment enchantment = Enchantment.ofNullable(entry);
                    if (enchantment != null) {
                        list.add(enchantment);
                    }
                });
            }
            return list;
        }
        return List.of();
    }

    @Override
    @NotNull
    public ItemData getData() {
        ItemMeta meta = ((org.bukkit.inventory.ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            if (BukkitFeature.ITEM_META_PDC.isSupported()) {
                return new BukkitItemDataPersistentContainer(meta.getPersistentDataContainer());
            }
            if (BukkitFeature.ITEM_META_CUSTOM_TAG.isSupported()) {
                return new BukkitItemDataCustomTags(meta.getCustomTagContainer());
            }
            Map unhandled = (Map)Reflect.getField((Object)meta, "unhandledTags");
            if (unhandled.containsKey("PublicBukkitValues")) {
                Object compound = unhandled.get("PublicBukkitValues");
                HashMap<String, Object> nmap = new HashMap<String, Object>();
                if (CompoundTagAccessor.TYPE.get().isInstance(compound)) {
                    Set keys = (Set)Reflect.fastInvoke(compound, CompoundTagAccessor.METHOD_KEY_SET.get());
                    for (Object key : keys) {
                        nmap.put(key.toString(), Reflect.fastInvoke(compound, CompoundTagAccessor.METHOD_GET.get(), key));
                    }
                }
                return new CraftBukkitItemData(nmap);
            }
            return new CraftBukkitItemData(new HashMap<String, Object>());
        }
        return new CraftBukkitItemData(new HashMap<String, Object>());
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull HideFlags> getHideFlags() {
        ItemMeta meta = ((org.bukkit.inventory.ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            return meta.getItemFlags().stream().map(Enum::name).map(HideFlags::convert).collect(Collectors.toList());
        }
        return List.of();
    }

    @Override
    @Nullable
    public Integer getCustomModelData() {
        ItemMeta meta = ((org.bukkit.inventory.ItemStack)this.wrappedObject).getItemMeta();
        if (BukkitFeature.ITEM_META_CUSTOM_MODEL_DATA.isSupported()) {
            return meta.getCustomModelData();
        }
        return null;
    }

    @Override
    public boolean isUnbreakable() {
        ItemMeta meta = ((org.bukkit.inventory.ItemStack)this.wrappedObject).getItemMeta();
        if (meta != null) {
            if (BukkitFeature.ITEM_META_IS_UNBREAKABLE.isSupported()) {
                return meta.isUnbreakable();
            }
            Object spigot = Reflect.fastInvoke((Object)meta, "spigot");
            if (spigot != null) {
                return (Boolean)Reflect.fastInvoke(spigot, "isUnbreakable");
            }
        }
        return false;
    }

    @Override
    public int getRepairCost() {
        ItemMeta meta = ((org.bukkit.inventory.ItemStack)this.wrappedObject).getItemMeta();
        if (meta instanceof Repairable) {
            return ((Repairable)meta).getRepairCost();
        }
        return 0;
    }

    @Override
    @NotNull
    public ItemStackBuilder builder() {
        return new BukkitItemBuilder(((org.bukkit.inventory.ItemStack)this.wrappedObject).clone());
    }

    @Override
    public boolean isSimilar(@NotNull ItemStack item) {
        return ((org.bukkit.inventory.ItemStack)this.wrappedObject).isSimilar(item.as(org.bukkit.inventory.ItemStack.class));
    }

    @Override
    @NotNull
    public ItemStack clone() {
        return new BukkitItem(((org.bukkit.inventory.ItemStack)this.wrappedObject).clone());
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        try {
            return super.as(type);
        }
        catch (Throwable ignored) {
            return ItemStackFactory.convertItem(this, type);
        }
    }

    @Override
    @NotNull
    public CompoundTag getTag() {
        Object nbtTag;
        boolean isMutable = this instanceof ItemStackView;
        if (!isMutable && this.tagCache != null) {
            return this.tagCache;
        }
        Object nmsStack = ClassStorage.stackAsNMS((org.bukkit.inventory.ItemStack)this.wrappedObject);
        if (ItemStackAccessor.METHOD_SAVE_1.get() != null || Version.isVersion(1, 21, 6)) {
            Object compound = Version.isVersion(1, 21, 6) ? DataFixerUtils.encodeItemStack(nmsStack) : Reflect.fastInvoke(nmsStack, ItemStackAccessor.METHOD_SAVE_1.get(), Reflect.fastInvoke(ClassStorage.getMinecraftServerObject(), MinecraftServerAccessor.METHOD_REGISTRY_ACCESS.get()), Reflect.construct(CompoundTagAccessor.CONSTRUCTOR_0.get(), new Object[0]));
            if (compound == null) {
                return CompoundTag.EMPTY;
            }
            nbtTag = Reflect.fastInvoke(compound, CompoundTagAccessor.METHOD_GET.get(), "components");
        } else {
            nbtTag = Reflect.fastInvoke(nmsStack, ItemStackAccessor.METHOD_GET_TAG.get());
        }
        if (nbtTag == null) {
            return CompoundTag.EMPTY;
        }
        Tag tag = NBTVanillaSerializer.deserialize(nbtTag);
        if (tag instanceof CompoundTag) {
            if (!isMutable) {
                this.tagCache = (CompoundTag)tag;
            }
            return (CompoundTag)tag;
        }
        return CompoundTag.EMPTY;
    }

    @Override
    @NotNull
    public CompoundTag asCompoundTag() {
        if (this.isAir()) {
            return CompoundTag.EMPTY;
        }
        Object nmsStack = Reflect.fastInvoke(ClassStorage.stackAsNMS((org.bukkit.inventory.ItemStack)this.wrappedObject), ItemStackAccessor.METHOD_COPY.get());
        Object compound = Version.isVersion(1, 21, 6) ? DataFixerUtils.encodeItemStack(nmsStack) : (ItemStackAccessor.METHOD_SAVE_1.get() != null ? Reflect.fastInvoke(nmsStack, ItemStackAccessor.METHOD_SAVE_1.get(), Reflect.fastInvoke(ClassStorage.getMinecraftServerObject(), MinecraftServerAccessor.METHOD_REGISTRY_ACCESS.get()), Reflect.construct(CompoundTagAccessor.CONSTRUCTOR_0.get(), new Object[0])) : Reflect.fastInvoke(nmsStack, ItemStackAccessor.METHOD_SAVE.get(), Reflect.construct(CompoundTagAccessor.CONSTRUCTOR_0.get(), new Object[0])));
        Tag tag = NBTVanillaSerializer.deserialize(compound);
        if (tag instanceof CompoundTag) {
            return (CompoundTag)tag;
        }
        return CompoundTag.EMPTY;
    }

    @Override
    @NotNull
    public String toString() {
        return ((org.bukkit.inventory.ItemStack)this.wrappedObject).toString();
    }
}

