/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.ItemType;
import sba.sl.impl.bukkit.item.BukkitItemType1_13;
import sba.sl.impl.bukkit.item.MaterialRegistry1_13_X;
import sba.sl.impl.bukkit.tags.KeyedUtils;
import sba.sl.impl.item.ItemTypeRegistry;
import sba.sl.impl.item.tags.ModernItemTagsBackPorts;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItemStream;

public class BukkitItemTypeRegistry1_13
extends ItemTypeRegistry {
    @NotNull
    private static final @NotNull Map<@NotNull Material, List<String>> tagBackPorts = new HashMap<Material, List<String>>();

    public BukkitItemTypeRegistry1_13() {
        this.specialType(Material.class, mat -> mat.isItem() ? new BukkitItemType1_13((Material)mat) : null);
        this.specialType(ItemStack.class, stack -> new BukkitItemType1_13(stack.getType()));
        tagBackPorts.clear();
        Arrays.stream(Material.values()).filter(t -> !t.isLegacy() && t.isItem()).forEach(material -> {
            List<String> backPorts;
            if ("minecraft".equals(material.getKey().getNamespace()) && (backPorts = ModernItemTagsBackPorts.getPortedTags(new BukkitItemType1_13((Material)material), s -> KeyedUtils.isTagged("items", new NamespacedKey("minecraft", s.toLowerCase(Locale.ROOT)), Material.class, material))) != null && !backPorts.isEmpty()) {
                tagBackPorts.put((Material)material, backPorts);
            }
        });
    }

    @Override
    @Nullable
    protected ItemType resolveMappingPlatform(@NotNull ResourceLocation location) {
        Material material = MaterialRegistry1_13_X.getInstance().get(new NamespacedKey(location.namespace(), location.path()));
        if (material != null && material.isItem()) {
            return new BukkitItemType1_13(material);
        }
        return null;
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull ItemType> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<Material, ItemType>(() -> Arrays.stream(Material.values()).filter(t -> !t.isLegacy() && t.isItem()), BukkitItemType1_13::new, material -> ResourceLocation.of(material.getKey().getNamespace(), material.getKey().getKey()), (material, literal) -> material.getKey().getKey().contains((CharSequence)literal), (material, namespace) -> material.getKey().getNamespace().equals(namespace), List.of());
    }

    public static boolean hasTagInBackPorts(@NotNull Material material, @NotNull String tag) {
        return tagBackPorts.containsKey(material) && tagBackPorts.get(material).contains(tag);
    }
}

