/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item.data;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.data.ItemData;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.nms.accessors.nbt.ByteArrayTagAccessor;
import sba.sl.impl.nms.accessors.nbt.ByteTagAccessor;
import sba.sl.impl.nms.accessors.nbt.DoubleTagAccessor;
import sba.sl.impl.nms.accessors.nbt.FloatTagAccessor;
import sba.sl.impl.nms.accessors.nbt.IntArrayTagAccessor;
import sba.sl.impl.nms.accessors.nbt.IntTagAccessor;
import sba.sl.impl.nms.accessors.nbt.LongArrayTagAccessor;
import sba.sl.impl.nms.accessors.nbt.LongTagAccessor;
import sba.sl.impl.nms.accessors.nbt.ShortTagAccessor;
import sba.sl.impl.nms.accessors.nbt.StringTagAccessor;
import sba.sl.impl.nms.accessors.nbt.TagAccessor;
import sba.sl.impl.utils.GsonUtils;
import sba.sl.impl.utils.Primitives;
import sba.sl.u.ResourceLocation;
import sba.sl.u.reflect.Reflect;

public class CraftBukkitItemData
implements ItemData {
    @NotNull
    private final @NotNull Map<@NotNull String, Object> keyNBTMap;

    @Override
    @NotNull
    public @NotNull Set<@NotNull ResourceLocation> getKeys() {
        return this.keyNBTMap.keySet().stream().map(ResourceLocation::of).collect(Collectors.toSet());
    }

    @Override
    public <T> void set(@NotNull String key, @NotNull T data, @NotNull Class<T> tClass) {
        this.set(ResourceLocation.of(BukkitCore.getPlugin().getName().toLowerCase(Locale.ROOT), key.toLowerCase(Locale.ROOT)), data, tClass);
    }

    @Override
    public <T> void set(@NotNull ResourceLocation key, @NotNull T data, @NotNull Class<T> tClass) {
        if (!Primitives.isWrapperType(tClass)) {
            tClass = Primitives.wrap(tClass);
        }
        if (tClass == byte[].class) {
            this.keyNBTMap.put(key.asString(), Reflect.construct(ByteArrayTagAccessor.CONSTRUCTOR_0.get(), data));
        } else if (tClass == Byte.class) {
            this.keyNBTMap.put(key.asString(), ByteTagAccessor.METHOD_VALUE_OF.get() != null ? Reflect.fastInvoke(ByteTagAccessor.METHOD_VALUE_OF.get(), data) : Reflect.construct(ByteTagAccessor.CONSTRUCTOR_0.get(), data));
        } else if (tClass == Double.class) {
            this.keyNBTMap.put(key.asString(), DoubleTagAccessor.METHOD_VALUE_OF.get() != null ? Reflect.fastInvoke(DoubleTagAccessor.METHOD_VALUE_OF.get(), data) : Reflect.construct(DoubleTagAccessor.CONSTRUCTOR_0.get(), data));
        } else if (tClass == Float.class) {
            this.keyNBTMap.put(key.asString(), FloatTagAccessor.METHOD_VALUE_OF.get() != null ? Reflect.fastInvoke(FloatTagAccessor.METHOD_VALUE_OF.get(), data) : Reflect.construct(FloatTagAccessor.CONSTRUCTOR_0.get(), data));
        } else if (tClass == int[].class) {
            this.keyNBTMap.put(key.asString(), Reflect.construct(IntArrayTagAccessor.CONSTRUCTOR_0.get(), data));
        } else if (tClass == Integer.class) {
            this.keyNBTMap.put(key.asString(), IntTagAccessor.METHOD_VALUE_OF.get() != null ? Reflect.fastInvoke(IntTagAccessor.METHOD_VALUE_OF.get(), data) : Reflect.construct(IntTagAccessor.CONSTRUCTOR_0.get(), data));
        } else if (tClass == long[].class) {
            this.keyNBTMap.put(key.asString(), Reflect.construct(LongArrayTagAccessor.CONSTRUCTOR_0.get(), data));
        } else if (tClass == Long.class) {
            this.keyNBTMap.put(key.asString(), LongTagAccessor.METHOD_VALUE_OF.get() != null ? Reflect.fastInvoke(LongTagAccessor.METHOD_VALUE_OF.get(), data) : Reflect.construct(LongTagAccessor.CONSTRUCTOR_0.get(), data));
        } else if (tClass == Short.class) {
            this.keyNBTMap.put(key.asString(), ShortTagAccessor.METHOD_VALUE_OF.get() != null ? Reflect.fastInvoke(ShortTagAccessor.METHOD_VALUE_OF.get(), data) : Reflect.construct(ShortTagAccessor.CONSTRUCTOR_0.get(), data));
        } else if (tClass == String.class) {
            this.keyNBTMap.put(key.asString(), StringTagAccessor.METHOD_VALUE_OF.get() != null ? Reflect.fastInvoke(StringTagAccessor.METHOD_VALUE_OF.get(), data) : Reflect.construct(StringTagAccessor.CONSTRUCTOR_0.get(), data));
        } else {
            this.keyNBTMap.put(key.asString(), GsonUtils.gson().toJson(data));
        }
    }

    @Override
    @Nullable
    public <T> T get(@NotNull String key, @NotNull Class<T> tClass) {
        return this.get(ResourceLocation.of(BukkitCore.getPlugin().getName().toLowerCase(Locale.ROOT), key.toLowerCase(Locale.ROOT)), tClass);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull ResourceLocation key, @NotNull Class<T> tClass) {
        Object nbt;
        if (!Primitives.isWrapperType(tClass)) {
            tClass = Primitives.wrap(tClass);
        }
        if ((nbt = this.keyNBTMap.get(key.asString())) == null) {
            return null;
        }
        if (ByteArrayTagAccessor.TYPE.get() == nbt.getClass() && tClass == byte[].class) {
            return (T)Reflect.fastInvoke(nbt, ByteArrayTagAccessor.METHOD_GET_AS_BYTE_ARRAY.get());
        }
        if (ByteTagAccessor.TYPE.get() == nbt.getClass() && tClass == Byte.class) {
            return (T)Reflect.fastInvoke(nbt, ByteTagAccessor.METHOD_BYTE_VALUE.get());
        }
        if (DoubleTagAccessor.TYPE.get() == nbt.getClass() && tClass == Double.class) {
            return (T)Reflect.fastInvoke(nbt, DoubleTagAccessor.METHOD_DOUBLE_VALUE.get());
        }
        if (FloatTagAccessor.TYPE.get() == nbt.getClass() && tClass == Float.class) {
            return (T)Reflect.fastInvoke(nbt, FloatTagAccessor.METHOD_FLOAT_VALUE.get());
        }
        if (IntArrayTagAccessor.TYPE.get() == nbt.getClass() && tClass == int[].class) {
            return (T)Reflect.fastInvoke(nbt, IntArrayTagAccessor.METHOD_GET_AS_INT_ARRAY.get());
        }
        if (IntTagAccessor.TYPE.get() == nbt.getClass() && tClass == Integer.class) {
            return (T)Reflect.fastInvoke(nbt, IntTagAccessor.METHOD_INT_VALUE.get());
        }
        if (LongArrayTagAccessor.TYPE.get() == nbt.getClass() && tClass == long[].class) {
            return (T)Reflect.fastInvoke(nbt, LongArrayTagAccessor.METHOD_GET_AS_LONG_ARRAY.get());
        }
        if (LongTagAccessor.TYPE.get() == nbt.getClass() && tClass == Long.class) {
            return (T)Reflect.fastInvoke(nbt, LongTagAccessor.METHOD_LONG_VALUE.get());
        }
        if (ShortTagAccessor.TYPE.get() == nbt.getClass() && tClass == Short.class) {
            return (T)Reflect.fastInvoke(nbt, ShortTagAccessor.METHOD_SHORT_VALUE.get());
        }
        if (tClass == String.class) {
            if (TagAccessor.METHOD_AS_STRING.get() != null) {
                return ((Optional)Reflect.fastInvoke(nbt, TagAccessor.METHOD_AS_STRING.get())).orElse(null);
            }
            return (T)Reflect.fastInvoke(nbt, TagAccessor.METHOD_GET_AS_STRING.get());
        }
        @Nullable String value = TagAccessor.METHOD_AS_STRING.get() != null ? (String)((Optional)Reflect.fastInvoke(nbt, TagAccessor.METHOD_AS_STRING.get())).orElse(null) : (String)Reflect.fastInvoke(nbt, TagAccessor.METHOD_GET_AS_STRING.get());
        return (T)GsonUtils.gson().fromJson(value, tClass);
    }

    @Override
    public boolean contains(@NotNull String key) {
        return this.keyNBTMap.containsKey(ResourceLocation.of(BukkitCore.getPlugin().getName().toLowerCase(Locale.ROOT), key.toLowerCase(Locale.ROOT)).asString());
    }

    @Override
    public boolean contains(@NotNull ResourceLocation key) {
        return this.keyNBTMap.containsKey(key.asString());
    }

    @Override
    public boolean isEmpty() {
        return this.keyNBTMap.isEmpty();
    }

    @Generated
    public CraftBukkitItemData(@NotNull @NotNull Map<@NotNull String, Object> keyNBTMap) {
        if (keyNBTMap == null) {
            throw new NullPointerException("keyNBTMap is marked non-null but is null");
        }
        this.keyNBTMap = keyNBTMap;
    }

    @NotNull
    @Generated
    public @NotNull Map<@NotNull String, Object> getKeyNBTMap() {
        return this.keyNBTMap;
    }
}

