/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item.meta;

import java.util.Arrays;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.i.meta.EnchantmentType;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.item.meta.BukkitEnchantment;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class BukkitEnchantmentType
extends BasicWrapper<Enchantment>
implements EnchantmentType {
    public BukkitEnchantmentType(@NotNull Enchantment enchantment) {
        super(enchantment);
    }

    @Override
    @NotNull
    public String platformName() {
        return ((Enchantment)this.wrappedObject).getName();
    }

    @Override
    @NotNull
    public sba.sl.i.meta.Enchantment asEnchantment(int level) {
        return new BukkitEnchantment((Enchantment)this.wrappedObject, level);
    }

    @Override
    public boolean is(@Nullable Object object) {
        if (object instanceof Enchantment) {
            return ((Enchantment)this.wrappedObject).equals(object);
        }
        if (object instanceof EnchantmentType) {
            return this.equals(object);
        }
        return this.equals(EnchantmentType.ofNullable(object));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        return super.as(type);
    }

    @Override
    @NotNull
    public ResourceLocation location() {
        if (BukkitFeature.FLATTENING.isSupported()) {
            NamespacedKey bukkitKey = ((Enchantment)this.wrappedObject).getKey();
            return ResourceLocation.of(bukkitKey.getNamespace(), bukkitKey.getKey());
        }
        return ResourceLocation.of(BukkitEnchantmentType.getLocationPath((Enchantment)this.wrappedObject));
    }

    @NotNull
    public static String getLocationPath(@NotNull Enchantment enchantment) {
        String path;
        switch (path = enchantment.getName()) {
            case "PROTECTION_ENVIRONMENTAL": {
                path = "protection";
                break;
            }
            case "PROTECTION_FIRE": {
                path = "fire_protection";
                break;
            }
            case "PROTECTION_FALL": {
                path = "feather_falling";
                break;
            }
            case "PROTECTION_EXPLOSIONS": {
                path = "blast_protection";
                break;
            }
            case "PROTECTION_PROJECTILE": {
                path = "projectile_protection";
                break;
            }
            case "OXYGEN": {
                path = "respiration";
                break;
            }
            case "WATER_WORKER": {
                path = "aqua_affinity";
                break;
            }
            case "DAMAGE_ALL": {
                path = "sharpness";
                break;
            }
            case "DAMAGE_UNDEAD": {
                path = "smite";
                break;
            }
            case "DAMAGE_ARTHROPODS": {
                path = "bane_of_arthropods";
                break;
            }
            case "LOOT_BONUS_MOBS": {
                path = "looting";
                break;
            }
            case "SWEEPING_EDGE": {
                path = "sweeping";
                break;
            }
            case "DIG_SPEED": {
                path = "efficiency";
                break;
            }
            case "DURABILITY": {
                path = "unbreaking";
                break;
            }
            case "LOOT_BONUS_BLOCKS": {
                path = "fortune";
                break;
            }
            case "ARROW_DAMAGE": {
                path = "power";
                break;
            }
            case "ARROW_KNOCKBACK": {
                path = "punch";
                break;
            }
            case "ARROW_FIRE": {
                path = "flame";
                break;
            }
            case "ARROW_INFINITE": {
                path = "infinity";
                break;
            }
            case "LUCK": {
                path = "luck_of_the_sea";
            }
        }
        return path.toLowerCase(Locale.ROOT);
    }
}

