/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.particle;

import java.util.Arrays;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.Block;
import sba.sl.i.ItemStack;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.pa.DustOptions;
import sba.sl.pa.DustTransition;
import sba.sl.pa.FloatData;
import sba.sl.pa.IntegerData;
import sba.sl.pa.ParticleColor;
import sba.sl.pa.ParticleData;
import sba.sl.pa.ParticleType;
import sba.sl.pa.Trail;
import sba.sl.pa.Vibration;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class BukkitParticleType1_9
extends BasicWrapper<Particle>
implements ParticleType {
    public BukkitParticleType1_9(@NotNull Particle wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public String platformName() {
        return ((Particle)this.wrappedObject).name();
    }

    @Override
    @Nullable
    public Class<? extends ParticleData> expectedDataClass() {
        Class dataType = ((Particle)this.wrappedObject).getDataType();
        if (dataType != Void.class) {
            switch (dataType.getSimpleName()) {
                case "MaterialData": 
                case "BlockData": {
                    return Block.class;
                }
                case "ItemStack": {
                    return ItemStack.class;
                }
                case "DustOptions": {
                    return DustOptions.class;
                }
                case "DustTransition": {
                    return DustTransition.class;
                }
                case "Integer": {
                    return IntegerData.class;
                }
                case "Float": {
                    return FloatData.class;
                }
                case "Vibration": {
                    return Vibration.class;
                }
                case "Color": {
                    return ParticleColor.class;
                }
                case "TargetColor": 
                case "Trail": {
                    return Trail.class;
                }
            }
        }
        return null;
    }

    @Override
    public boolean is(@Nullable Object object) {
        if (object instanceof Particle || object instanceof ParticleType) {
            return this.equals(object);
        }
        return this.equals(ParticleType.ofNullable(object));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    @NotNull
    public ResourceLocation location() {
        if (BukkitFeature.PARTICLE_REGISTRY.isSupported()) {
            NamespacedKey key = ((Particle)this.wrappedObject).getKey();
            return ResourceLocation.of(key.getNamespace(), key.getKey());
        }
        return ResourceLocation.of(BukkitParticleType1_9.convertPath((Particle)this.wrappedObject));
    }

    @NotNull
    public static String convertPath(@NotNull Particle particle) {
        switch (particle.name()) {
            case "EXPLOSION_NORMAL": {
                return "poof";
            }
            case "EXPLOSION_LARGE": {
                return "explosion";
            }
            case "EXPLOSION_HUGE": {
                return "explosion_emitter";
            }
            case "FIREWORKS_SPARK": {
                return "firework";
            }
            case "WATER_BUBBLE": {
                return "bubble";
            }
            case "WATER_SPLASH": {
                return "splash";
            }
            case "WATER_WAKE": {
                return "fishing";
            }
            case "SUSPENDED": {
                return "underwater";
            }
            case "CRIT_MAGIC": {
                return "enchanted_hit";
            }
            case "SMOKE_NORMAL": {
                return "smoke";
            }
            case "SMOKE_LARGE": {
                return "large_smoke";
            }
            case "SPELL": {
                return "effect";
            }
            case "SPELL_INSTANT": {
                return "instant_effect";
            }
            case "SPELL_MOB": {
                return "entity_effect";
            }
            case "SPELL_MOB_AMBIENT": {
                return "ambient_entity_effect";
            }
            case "SPELL_WITCH": {
                return "witch";
            }
            case "DRIP_WATER": {
                return "dripping_water";
            }
            case "DRIP_LAVA": {
                return "dripping_lava";
            }
            case "VILLAGER_ANGRY": {
                return "angry_villager";
            }
            case "VILLAGER_HAPPY": {
                return "happy_villager";
            }
            case "TOWN_AURA": {
                return "mycelium";
            }
            case "ENCHANTMENT_TABLE": {
                return "enchant";
            }
            case "REDSTONE": {
                return "dust";
            }
            case "SNOWBALL": {
                return "item_snowball";
            }
            case "SLIME": {
                return "item_slime";
            }
            case "ITEM_CRACK": {
                return "item";
            }
            case "BLOCK_CRACK": {
                return "block";
            }
            case "WATER_DROP": {
                return "rain";
            }
            case "MOB_APPEARANCE": {
                return "elder_guardian";
            }
            case "TOTEM": {
                return "totem_of_undying";
            }
            case "BARRIER": 
            case "LIGHT": {
                return "block_marker";
            }
        }
        return particle.name().toLowerCase(Locale.ROOT);
    }
}

