/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bungee.spectator.event.hover;

import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bungee.spectator.AbstractBungeeBackend;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.StringTag;
import sba.sl.nbt.Tag;
import sba.sl.spectator.Component;
import sba.sl.spectator.event.hover.EntityContent;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class BungeeLegacyEntityContent
extends BasicWrapper<CompoundTag>
implements EntityContent {
    public BungeeLegacyEntityContent(@NotNull String snbt) {
        this(BungeeLegacyEntityContent.readTag(snbt));
    }

    public BungeeLegacyEntityContent(@NotNull CompoundTag tag) {
        super(tag);
    }

    @NotNull
    private static CompoundTag readTag(@NotNull String snbt) {
        Tag tag = AbstractBungeeBackend.getSnbtSerializer().deserialize(snbt);
        if (tag instanceof CompoundTag) {
            return (CompoundTag)tag;
        }
        return CompoundTag.EMPTY;
    }

    @Override
    @NotNull
    public UUID id() {
        Tag string = ((CompoundTag)this.wrappedObject).tag("id");
        if (string instanceof StringTag) {
            return UUID.fromString(((StringTag)string).value());
        }
        return UUID.randomUUID();
    }

    @Override
    @NotNull
    public EntityContent withId(@NotNull UUID id) {
        return new BungeeLegacyEntityContent(((CompoundTag)this.wrappedObject).with("id", id.toString()));
    }

    @Override
    @NotNull
    public ResourceLocation type() {
        Tag string = ((CompoundTag)this.wrappedObject).tag("type");
        if (string instanceof StringTag) {
            return ResourceLocation.of(((StringTag)string).value());
        }
        return ResourceLocation.of("minecraft", "pig");
    }

    @Override
    @NotNull
    public EntityContent withType(@NotNull ResourceLocation type) {
        return new BungeeLegacyEntityContent(((CompoundTag)this.wrappedObject).with("type", type.asString()));
    }

    @Override
    @Nullable
    public Component name() {
        Tag name = ((CompoundTag)this.wrappedObject).tag("name");
        if (name instanceof StringTag) {
            return Component.fromJavaJson(((StringTag)name).value());
        }
        return null;
    }

    @Override
    @NotNull
    public EntityContent withType(@Nullable Component name) {
        if (name != null) {
            return new BungeeLegacyEntityContent(((CompoundTag)this.wrappedObject).with("name", name.toJavaJson()));
        }
        return new BungeeLegacyEntityContent(((CompoundTag)this.wrappedObject).without("name"));
    }

    @Override
    public @NotNull EntityContent.Builder toBuilder() {
        return new BungeeLegacyEntityContentBuilder(this.id(), this.type(), this.name());
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type == String.class) {
            return (T)AbstractBungeeBackend.getSnbtSerializer().serialize((Tag)this.wrappedObject);
        }
        return super.as(type);
    }

    public static class BungeeLegacyEntityContentBuilder
    implements EntityContent.Builder {
        @Nullable
        private UUID id;
        @Nullable
        private ResourceLocation type;
        @Nullable
        private Component name;

        @Override
        @NotNull
        public EntityContent build() {
            CompoundTag compound = CompoundTag.EMPTY.with("id", this.id != null ? this.id.toString() : UUID.randomUUID().toString()).with("type", this.type != null ? this.type.asString() : "minecraft:pig");
            if (this.name != null) {
                compound = compound.with("name", this.name.toJavaJson());
            }
            return new BungeeLegacyEntityContent(compound);
        }

        @Generated
        public BungeeLegacyEntityContentBuilder() {
        }

        @Generated
        public BungeeLegacyEntityContentBuilder(@Nullable UUID id, @Nullable ResourceLocation type, @Nullable Component name) {
            this.id = id;
            this.type = type;
            this.name = name;
        }

        @Override
        @Generated
        public BungeeLegacyEntityContentBuilder id(@Nullable UUID id) {
            this.id = id;
            return this;
        }

        @Override
        @Generated
        public BungeeLegacyEntityContentBuilder type(@Nullable ResourceLocation type) {
            this.type = type;
            return this;
        }

        @Override
        @Generated
        public BungeeLegacyEntityContentBuilder name(@Nullable Component name) {
            this.name = name;
            return this;
        }
    }
}

