/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.ext.takenaka.platform;

import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.ext.takenaka.platform.MapperPlatform;

@ApiStatus.Internal
public class MapperPlatformImpl
implements MapperPlatform {
    private final String version;
    private final String[] mappingNamespaces;
    private final ClassLoader classLoader;

    protected MapperPlatformImpl(@NotNull String version, @NotNull String[] mappingNamespaces, @Nullable ClassLoader classLoader) {
        this.version = version;
        this.mappingNamespaces = mappingNamespaces;
        this.classLoader = classLoader;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public String[] getMappingNamespaces() {
        return this.mappingNamespaces;
    }

    @Override
    @NotNull
    public ClassLoader getClassLoader() {
        return this.classLoader == null ? Thread.currentThread().getContextClassLoader() : this.classLoader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapperPlatformImpl that = (MapperPlatformImpl)o;
        return Objects.equals(this.version, that.version) && Arrays.equals(this.mappingNamespaces, that.mappingNamespaces) && Objects.equals(this.classLoader, that.classLoader);
    }

    public int hashCode() {
        int result = Objects.hash(this.version, this.classLoader);
        result = 31 * result + Arrays.hashCode(this.mappingNamespaces);
        return result;
    }

    public String toString() {
        return "MapperPlatformImpl{version='" + this.version + '\'' + ", mappingNamespaces=" + Arrays.toString(this.mappingNamespaces) + ", classLoader=" + this.classLoader + '}';
    }
}

