/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.item.builder;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.ConfigurationNode;
import sba.sl.i.ItemType;
import sba.sl.i.builder.ItemStackBuilder;
import sba.sl.spectator.Component;

public final class ShortStackDeserializer {
    @NotNull
    public static final Pattern SHORT_STACK_PATTERN = Pattern.compile("^(?<material>(?:(?!(?<!\\\\)(?:\\\\\\\\)*;).)+)(\\\\*)?(;(?<amount>(?:(?!(?<!\\\\)(?:\\\\\\\\)*;).)+)?(\\\\*)?(;(?<name>(\"((?!(?<!\\\\)(?:\\\\\\\\)*\").)+|(?:(?!(?<!\\\\)(?:\\\\\\\\)*;).)+))?(\\\\*)?(;(?<lore>.*))?)?)?$");
    @NotNull
    public static final Pattern LORE_SPLIT = Pattern.compile("((\"((?!(?<!\\\\)(?:\\\\\\\\)*\").)+\")|((?!(?<!\\\\)(?:\\\\\\\\)*;).)+)(?=($|;))");

    public static void deserializeShortStack(@NotNull ItemStackBuilder builder, @Nullable Object shortStackObject) {
        ItemType materialHolder;
        Matcher matcher;
        ItemType opt;
        if (shortStackObject instanceof ConfigurationNode) {
            shortStackObject = ((ConfigurationNode)shortStackObject).getString();
        }
        if (!(shortStackObject instanceof String) && (opt = ItemType.ofNullable(shortStackObject)) != null) {
            builder.type(opt);
            return;
        }
        if (shortStackObject == null) {
            return;
        }
        String shortStack = shortStackObject.toString().trim();
        if (shortStack.startsWith("(cast to ItemStack)")) {
            shortStack = shortStack.substring(19).trim();
        }
        if (!(matcher = SHORT_STACK_PATTERN.matcher(shortStack)).matches() || matcher.group("material") == null) {
            return;
        }
        String material = matcher.group("material");
        String amount = matcher.group("amount");
        String name = matcher.group("name");
        if (name != null && name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        String loreString = matcher.group("lore");
        ArrayList<String> lore = new ArrayList<String>();
        if (loreString != null) {
            Matcher loreMatcher = LORE_SPLIT.matcher(loreString);
            while (loreMatcher.find()) {
                lore.add(loreMatcher.group());
            }
        }
        if ((materialHolder = ItemType.ofNullable(material)) == null) {
            return;
        }
        builder.type(materialHolder);
        try {
            if (amount != null && !amount.trim().isEmpty()) {
                builder.amount(Integer.parseInt(amount.trim()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (name != null && !name.trim().isEmpty()) {
            builder.displayName(Component.fromLegacy(name.trim()));
        }
        builder.itemLore(lore.stream().map(Component::fromLegacy).collect(Collectors.toList()));
    }

    @Generated
    private ShortStackDeserializer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

