/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.vanilla.nbt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.impl.nms.accessors.nbt.ByteArrayTagAccessor;
import sba.sl.impl.nms.accessors.nbt.ByteTagAccessor;
import sba.sl.impl.nms.accessors.nbt.CompoundTagAccessor;
import sba.sl.impl.nms.accessors.nbt.DoubleTagAccessor;
import sba.sl.impl.nms.accessors.nbt.FloatTagAccessor;
import sba.sl.impl.nms.accessors.nbt.IntArrayTagAccessor;
import sba.sl.impl.nms.accessors.nbt.IntTagAccessor;
import sba.sl.impl.nms.accessors.nbt.ListTagAccessor;
import sba.sl.impl.nms.accessors.nbt.LongArrayTagAccessor;
import sba.sl.impl.nms.accessors.nbt.LongTagAccessor;
import sba.sl.impl.nms.accessors.nbt.ShortTagAccessor;
import sba.sl.impl.nms.accessors.nbt.StringTagAccessor;
import sba.sl.impl.nms.accessors.nbt.TagAccessor;
import sba.sl.nbt.ByteArrayTag;
import sba.sl.nbt.ByteTag;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.DoubleTag;
import sba.sl.nbt.FloatTag;
import sba.sl.nbt.IntArrayTag;
import sba.sl.nbt.IntTag;
import sba.sl.nbt.ListTag;
import sba.sl.nbt.LongArrayTag;
import sba.sl.nbt.LongTag;
import sba.sl.nbt.NumericTag;
import sba.sl.nbt.ShortTag;
import sba.sl.nbt.StringTag;
import sba.sl.nbt.Tag;
import sba.sl.u.Preconditions;
import sba.sl.u.reflect.Reflect;

public final class NBTVanillaSerializer {
    @NotNull
    public static Tag deserialize(@NotNull Object nmsTag) {
        Preconditions.checkArgument(TagAccessor.TYPE.get().isInstance(nmsTag), "nmsTag must be of type " + TagAccessor.TYPE.get().getName() + ", got " + String.valueOf(nmsTag));
        if (ByteTagAccessor.TYPE.get().isInstance(nmsTag)) {
            return new ByteTag((Byte)Reflect.fastInvoke(nmsTag, ByteTagAccessor.METHOD_BYTE_VALUE.get()));
        }
        if (ShortTagAccessor.TYPE.get().isInstance(nmsTag)) {
            return new ShortTag((Short)Reflect.fastInvoke(nmsTag, ShortTagAccessor.METHOD_SHORT_VALUE.get()));
        }
        if (IntTagAccessor.TYPE.get().isInstance(nmsTag)) {
            return new IntTag((Integer)Reflect.fastInvoke(nmsTag, IntTagAccessor.METHOD_INT_VALUE.get()));
        }
        if (LongTagAccessor.TYPE.get().isInstance(nmsTag)) {
            return new LongTag((Long)Reflect.fastInvoke(nmsTag, LongTagAccessor.METHOD_LONG_VALUE.get()));
        }
        if (StringTagAccessor.TYPE.get().isInstance(nmsTag)) {
            if (TagAccessor.METHOD_AS_STRING.get() != null) {
                return new StringTag(((Optional)Reflect.fastInvoke(nmsTag, TagAccessor.METHOD_AS_STRING.get())).orElse(""));
            }
            return new StringTag((String)Reflect.fastInvoke(nmsTag, TagAccessor.METHOD_GET_AS_STRING.get()));
        }
        if (FloatTagAccessor.TYPE.get().isInstance(nmsTag)) {
            return new FloatTag(((Float)Reflect.fastInvoke(nmsTag, FloatTagAccessor.METHOD_FLOAT_VALUE.get())).floatValue());
        }
        if (DoubleTagAccessor.TYPE.get().isInstance(nmsTag)) {
            return new DoubleTag((Double)Reflect.fastInvoke(nmsTag, DoubleTagAccessor.METHOD_DOUBLE_VALUE.get()));
        }
        if (CompoundTagAccessor.TYPE.get().isInstance(nmsTag)) {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Object key : (Iterable)Reflect.fastInvoke(nmsTag, CompoundTagAccessor.METHOD_KEY_SET.get())) {
                map.put(key.toString(), NBTVanillaSerializer.deserialize(Reflect.fastInvoke(nmsTag, CompoundTagAccessor.METHOD_GET.get(), key)));
            }
            return new CompoundTag(map);
        }
        if (ListTagAccessor.TYPE.get().isInstance(nmsTag)) {
            int size = (Integer)Reflect.fastInvoke(nmsTag, ListTagAccessor.METHOD_SIZE.get());
            ArrayList<Tag> list = new ArrayList<Tag>(size);
            boolean isJavaUtilList = nmsTag instanceof List;
            for (int i = 0; i < size; ++i) {
                if (isJavaUtilList) {
                    list.add(NBTVanillaSerializer.deserialize(((List)nmsTag).get(i)));
                    continue;
                }
                Object entry = Reflect.fastInvoke(nmsTag, ListTagAccessor.METHOD_GET.get(), i);
                list.add(NBTVanillaSerializer.deserialize(entry));
            }
            return new ListTag(list);
        }
        if (ByteArrayTagAccessor.TYPE.get().isInstance(nmsTag)) {
            return new ByteArrayTag((byte[])Reflect.fastInvoke(nmsTag, ByteArrayTagAccessor.METHOD_GET_AS_BYTE_ARRAY.get()));
        }
        if (IntArrayTagAccessor.TYPE.get().isInstance(nmsTag)) {
            return new IntArrayTag((int[])Reflect.fastInvoke(nmsTag, IntArrayTagAccessor.METHOD_GET_AS_INT_ARRAY.get()));
        }
        if (LongArrayTagAccessor.TYPE.get() != null && LongArrayTagAccessor.TYPE.get().isInstance(nmsTag)) {
            if (LongArrayTagAccessor.METHOD_GET_AS_LONG_ARRAY.get() != null) {
                return new LongArrayTag((long[])Reflect.fastInvoke(nmsTag, LongArrayTagAccessor.METHOD_GET_AS_LONG_ARRAY.get()));
            }
            return new LongArrayTag((long[])Objects.requireNonNull(Reflect.getField(nmsTag, LongArrayTagAccessor.FIELD_FIELD_193587_B.get())));
        }
        throw new IllegalArgumentException("Unknown tag " + String.valueOf(nmsTag));
    }

    @NotNull
    public static Object serialize(@NotNull Tag tag) {
        if (tag instanceof ByteTag) {
            return Reflect.construct(ByteTagAccessor.CONSTRUCTOR_0.get(), ((NumericTag)tag).byteValue());
        }
        if (tag instanceof ShortTag) {
            return Reflect.construct(ShortTagAccessor.CONSTRUCTOR_0.get(), ((NumericTag)tag).shortValue());
        }
        if (tag instanceof IntTag) {
            return Reflect.construct(IntTagAccessor.CONSTRUCTOR_0.get(), ((NumericTag)tag).intValue());
        }
        if (tag instanceof LongTag) {
            return Reflect.construct(LongTagAccessor.CONSTRUCTOR_0.get(), ((NumericTag)tag).longValue());
        }
        if (tag instanceof StringTag) {
            return Reflect.construct(StringTagAccessor.CONSTRUCTOR_0.get(), ((StringTag)tag).value());
        }
        if (tag instanceof FloatTag) {
            return Reflect.construct(FloatTagAccessor.CONSTRUCTOR_0.get(), Float.valueOf(((NumericTag)tag).floatValue()));
        }
        if (tag instanceof DoubleTag) {
            return Reflect.construct(DoubleTagAccessor.CONSTRUCTOR_0.get(), ((NumericTag)tag).doubleValue());
        }
        if (tag instanceof CompoundTag) {
            Object compound = Reflect.construct(CompoundTagAccessor.CONSTRUCTOR_0.get(), new Object[0]);
            for (Map.Entry<String, Tag> entry : ((CompoundTag)tag).value().entrySet()) {
                Reflect.fastInvoke(compound, CompoundTagAccessor.METHOD_PUT.get(), entry.getKey(), NBTVanillaSerializer.serialize(entry.getValue()));
            }
            return compound;
        }
        if (tag instanceof ListTag) {
            Object list = Reflect.construct(ListTagAccessor.CONSTRUCTOR_0.get(), new Object[0]);
            boolean isJavaUtilList = list instanceof List;
            for (Tag entry : (ListTag)tag) {
                if (isJavaUtilList) {
                    ((List)list).add(NBTVanillaSerializer.serialize(entry));
                    continue;
                }
                Reflect.fastInvoke(list, ListTagAccessor.METHOD_ADD.get(), NBTVanillaSerializer.serialize(entry));
            }
            return list;
        }
        if (tag instanceof ByteArrayTag) {
            return Reflect.construct(ByteArrayTagAccessor.CONSTRUCTOR_0.get(), new Object[]{((ByteArrayTag)tag).value()});
        }
        if (tag instanceof IntArrayTag) {
            return Reflect.construct(IntArrayTagAccessor.CONSTRUCTOR_0.get(), new Object[]{((IntArrayTag)tag).value()});
        }
        if (tag instanceof LongArrayTag) {
            if (LongArrayTagAccessor.TYPE.get() != null) {
                return Reflect.construct(LongArrayTagAccessor.CONSTRUCTOR_0.get(), new Object[]{((LongArrayTag)tag).value()});
            }
            Object list = Reflect.construct(ListTagAccessor.CONSTRUCTOR_0.get(), new Object[0]);
            boolean isJavaUtilList = list instanceof List;
            for (Long entry : (LongArrayTag)tag) {
                if (isJavaUtilList) {
                    ((List)list).add(Reflect.construct(LongTagAccessor.CONSTRUCTOR_0.get(), entry));
                    continue;
                }
                Reflect.fastInvoke(list, ListTagAccessor.METHOD_ADD.get(), Reflect.construct(LongTagAccessor.CONSTRUCTOR_0.get(), entry));
            }
            return list;
        }
        throw new IllegalArgumentException("Unknown tag " + String.valueOf(tag));
    }

    @Generated
    private NBTVanillaSerializer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

