/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.nbt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import sba.sl.nbt.CollectionTag;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.NumericTag;
import sba.sl.nbt.Tag;

public final class ListTag
implements CollectionTag,
Iterable<Tag> {
    @NotNull
    public static final ListTag EMPTY = new ListTag(List.of());
    @NotNull
    private final @NotNull List<@NotNull Tag> tags;

    /*
     * WARNING - void declaration
     */
    public ListTag(@NotNull @NotNull List<? extends @NotNull Tag> tags) {
        this.tags = new ArrayList<Tag>(tags.size());
        Class<?> determinedType = null;
        for (Tag tag : tags) {
            void var4_4;
            if (determinedType == null) {
                determinedType = tag.getClass();
            } else if (!determinedType.isInstance(tag)) {
                if (!(tags.get(0) instanceof NumericTag && tag instanceof NumericTag && ((NumericTag)tags.get(0)).canHoldDataOfTag((NumericTag)tag))) {
                    this.tags.clear();
                    for (Tag tag2 : tags) {
                        if (tag2 instanceof CompoundTag) {
                            this.tags.add(tag2);
                            continue;
                        }
                        this.tags.add(CompoundTag.wrapper(tag2));
                    }
                    break;
                }
                NumericTag numericTag = ((NumericTag)tags.get(0)).convert((NumericTag)tag);
            }
            this.tags.add((Tag)var4_4);
        }
    }

    @NotNull
    public @NotNull List<@NotNull Tag> value() {
        return List.copyOf(this.tags);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public ListTag with(@NotNull Tag tag) {
        ArrayList<Tag> clone = new ArrayList<Tag>(this.tags);
        clone.add(tag);
        return new ListTag(clone);
    }

    @Contract(value="_,_ -> new", pure=true)
    @NotNull
    public ListTag withAt(int index, @NotNull Tag tag) {
        ArrayList<Tag> clone = new ArrayList<Tag>(this.tags);
        clone.set(index, tag);
        return new ListTag(clone);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public ListTag without(@NotNull Tag tag) {
        ArrayList<Tag> clone = new ArrayList<Tag>(this.tags);
        clone.remove(tag);
        return new ListTag(clone);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public ListTag without(int index) {
        ArrayList<Tag> clone = new ArrayList<Tag>(this.tags);
        clone.remove(index);
        return new ListTag(clone);
    }

    @NotNull
    public Tag get(int index) {
        return this.tags.get(index);
    }

    @Override
    @NotNull
    public Tag getAsTag(int index) {
        return this.get(index);
    }

    @Override
    public int size() {
        return this.tags.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull Tag> iterator() {
        return new Iterator<Tag>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor != ListTag.this.tags.size();
            }

            @Override
            @NotNull
            public Tag next() {
                try {
                    Tag tag = ListTag.this.tags.get(this.cursor);
                    ++this.cursor;
                    return tag;
                }
                catch (IndexOutOfBoundsException exception) {
                    throw new NoSuchElementException();
                }
            }
        };
    }

    @NotNull
    public @NotNull Stream<@NotNull Tag> stream() {
        return this.tags.stream();
    }

    @NotNull
    @Generated
    public @NotNull List<@NotNull Tag> tags() {
        return this.tags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListTag)) {
            return false;
        }
        ListTag other = (ListTag)o;
        List<Tag> this$tags = this.tags();
        List<Tag> other$tags = other.tags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Tag> $tags = this.tags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ListTag(tags=" + String.valueOf(this.tags()) + ")";
    }
}

