/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.npc;

import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.ev.EventManager;
import sba.sl.ev.OnEvent;
import sba.sl.ev.player.PlayerMoveEvent;
import sba.sl.h.HologramManager;
import sba.sl.npc.NPC;
import sba.sl.npc.NPCImpl;
import sba.sl.npc.event.NPCInteractEvent;
import sba.sl.pa.Player;
import sba.sl.u.InteractType;
import sba.sl.u.Preconditions;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.vi.AbstractVisualsManager;
import sba.sl.w.Location;

@Service
@ServiceDependencies(dependsOn={HologramManager.class})
public class NPCManager
extends AbstractVisualsManager<NPC> {
    @Nullable
    private static NPCManager manager;

    public NPCManager() {
        Preconditions.checkArgument(manager == null, "NPCManager has already been initialized!");
        manager = this;
    }

    public static boolean isInitialized() {
        return manager != null;
    }

    @NotNull
    public static @NotNull Map<@NotNull UUID, NPC> getActiveNPCS() {
        return Preconditions.checkNotNull(manager, "NPCManager is not initialized yet!").getActiveVisuals();
    }

    @Contract(value="null -> null")
    @Nullable
    public static NPC getNPC(@Nullable UUID uuid) {
        Preconditions.checkNotNull(manager, "NPCManager is not initialized yet!");
        return NPCManager.getActiveNPCS().get(uuid);
    }

    public static void addNPC(@NotNull NPC npc) {
        Preconditions.checkNotNull(manager, "NPCManager is not initialized yet!").addVisual(npc.uuid(), npc);
    }

    public static void removeNPC(@Nullable UUID uuid) {
        if (uuid != null) {
            Preconditions.checkNotNull(manager, "NPCManager is not initialized yet!").removeVisual(uuid);
        }
    }

    public static void removeNPC(@NotNull NPC npc) {
        NPCManager.removeNPC(npc.uuid());
    }

    @NotNull
    public static NPC npc(@NotNull Location holder) {
        UUID uuid = UUID.randomUUID();
        if (uuid.version() == 4) {
            long msb = uuid.getMostSignificantBits();
            msb &= 0xFFFFFFFFFFFFBFFFL;
            uuid = new UUID(msb |= 0x2000L, uuid.getLeastSignificantBits());
        }
        return NPCManager.npc(uuid, holder, true);
    }

    @NotNull
    public static NPC npc(@NotNull UUID uuid, @NotNull Location holder, boolean touchable) {
        Preconditions.checkNotNull(manager, "NPCManager is not initialized yet!");
        NPCImpl npc = new NPCImpl(uuid, holder, touchable);
        NPCManager.addNPC(npc);
        return npc;
    }

    @OnEvent
    public void onPlayerMove(@NotNull PlayerMoveEvent event) {
        if (this.activeVisuals.isEmpty()) {
            return;
        }
        Player player = event.player();
        for (NPC npc : this.activeVisuals.values()) {
            if (!npc.shown() || !npc.lookAtPlayer() || !npc.viewers().contains(player) || !player.getLocation().isWorldSame(npc.location()) || npc.location().getDistanceSquared(player.getLocation()) > 4096.0) continue;
            npc.lookAtLocation(event.newLocation(), player);
        }
    }

    @Override
    public void fireVisualTouchEvent(@NotNull Player sender, @NotNull NPC visual, @NotNull InteractType interactType) {
        EventManager.fireAsync(new NPCInteractEvent(sender, visual, interactType));
    }
}

