/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.p;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.p.AbstractPacket;
import sba.sl.p.PacketWriter;
import sba.sl.u.math.Vector3D;

public abstract class ClientboundMoveEntityPacket
extends AbstractPacket {
    private final int entityId;
    private final boolean onGround;

    @Override
    public void write(@NotNull PacketWriter writer) {
        writer.writeVarInt(this.entityId);
        if (this instanceof Pos) {
            writer.writeMove(((Pos)this).delta);
        } else if (this instanceof Rot) {
            writer.writeByteRotation(((Rot)this).yaw, ((Rot)this).pitch);
        } else if (this instanceof PosRot) {
            writer.writeMove(((PosRot)this).delta);
            writer.writeByteRotation(((PosRot)this).yaw, ((PosRot)this).pitch);
        }
        writer.writeBoolean(this.onGround);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundMoveEntityPacket)) {
            return false;
        }
        ClientboundMoveEntityPacket other = (ClientboundMoveEntityPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.entityId() != other.entityId()) {
            return false;
        }
        return this.onGround() == other.onGround();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClientboundMoveEntityPacket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.entityId();
        result = result * 59 + (this.onGround() ? 79 : 97);
        return result;
    }

    @Generated
    public ClientboundMoveEntityPacket(int entityId, boolean onGround) {
        this.entityId = entityId;
        this.onGround = onGround;
    }

    @Generated
    public int entityId() {
        return this.entityId;
    }

    @Generated
    public boolean onGround() {
        return this.onGround;
    }

    @Generated
    public String toString() {
        return "ClientboundMoveEntityPacket(entityId=" + this.entityId() + ", onGround=" + this.onGround() + ")";
    }

    public static final class Pos
    extends ClientboundMoveEntityPacket {
        @NotNull
        private final Vector3D delta;

        private Pos(int entityId, boolean onGround, @NotNull Vector3D delta) {
            super(entityId, onGround);
            this.delta = delta;
        }

        @Generated
        public static PosBuilder builder() {
            return new PosBuilder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pos)) {
                return false;
            }
            Pos other = (Pos)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Vector3D this$delta = this.delta();
            Vector3D other$delta = other.delta();
            return !(this$delta == null ? other$delta != null : !((Object)this$delta).equals(other$delta));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Pos;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Vector3D $delta = this.delta();
            result = result * 59 + ($delta == null ? 43 : ((Object)$delta).hashCode());
            return result;
        }

        @NotNull
        @Generated
        public Vector3D delta() {
            return this.delta;
        }

        @Override
        @Generated
        public String toString() {
            return "ClientboundMoveEntityPacket.Pos(super=" + super.toString() + ", delta=" + String.valueOf(this.delta()) + ")";
        }

        @Generated
        public static class PosBuilder {
            @Generated
            private int entityId;
            @Generated
            private boolean onGround;
            @Generated
            private Vector3D delta;

            @Generated
            PosBuilder() {
            }

            @Generated
            public PosBuilder entityId(int entityId) {
                this.entityId = entityId;
                return this;
            }

            @Generated
            public PosBuilder onGround(boolean onGround) {
                this.onGround = onGround;
                return this;
            }

            @Generated
            public PosBuilder delta(@NotNull Vector3D delta) {
                if (delta == null) {
                    throw new NullPointerException("delta is marked non-null but is null");
                }
                this.delta = delta;
                return this;
            }

            @Generated
            public Pos build() {
                return new Pos(this.entityId, this.onGround, this.delta);
            }

            @Generated
            public String toString() {
                return "ClientboundMoveEntityPacket.Pos.PosBuilder(entityId=" + this.entityId + ", onGround=" + this.onGround + ", delta=" + String.valueOf(this.delta) + ")";
            }
        }
    }

    public static final class Rot
    extends ClientboundMoveEntityPacket {
        private final float yaw;
        private final float pitch;

        private Rot(int entityId, boolean onGround, float yaw, float pitch) {
            super(entityId, onGround);
            this.yaw = yaw;
            this.pitch = pitch;
        }

        @Generated
        public static RotBuilder builder() {
            return new RotBuilder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Rot)) {
                return false;
            }
            Rot other = (Rot)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (Float.compare(this.yaw(), other.yaw()) != 0) {
                return false;
            }
            return Float.compare(this.pitch(), other.pitch()) == 0;
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Rot;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + Float.floatToIntBits(this.yaw());
            result = result * 59 + Float.floatToIntBits(this.pitch());
            return result;
        }

        @Generated
        public float yaw() {
            return this.yaw;
        }

        @Generated
        public float pitch() {
            return this.pitch;
        }

        @Override
        @Generated
        public String toString() {
            return "ClientboundMoveEntityPacket.Rot(super=" + super.toString() + ", yaw=" + this.yaw() + ", pitch=" + this.pitch() + ")";
        }

        @Generated
        public static class RotBuilder {
            @Generated
            private int entityId;
            @Generated
            private boolean onGround;
            @Generated
            private float yaw;
            @Generated
            private float pitch;

            @Generated
            RotBuilder() {
            }

            @Generated
            public RotBuilder entityId(int entityId) {
                this.entityId = entityId;
                return this;
            }

            @Generated
            public RotBuilder onGround(boolean onGround) {
                this.onGround = onGround;
                return this;
            }

            @Generated
            public RotBuilder yaw(float yaw) {
                this.yaw = yaw;
                return this;
            }

            @Generated
            public RotBuilder pitch(float pitch) {
                this.pitch = pitch;
                return this;
            }

            @Generated
            public Rot build() {
                return new Rot(this.entityId, this.onGround, this.yaw, this.pitch);
            }

            @Generated
            public String toString() {
                return "ClientboundMoveEntityPacket.Rot.RotBuilder(entityId=" + this.entityId + ", onGround=" + this.onGround + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ")";
            }
        }
    }

    public static final class PosRot
    extends ClientboundMoveEntityPacket {
        @NotNull
        private final Vector3D delta;
        private final float yaw;
        private final float pitch;

        private PosRot(int entityId, boolean onGround, @NotNull Vector3D delta, float yaw, float pitch) {
            super(entityId, onGround);
            this.delta = delta;
            this.yaw = yaw;
            this.pitch = pitch;
        }

        @Generated
        public static PosRotBuilder builder() {
            return new PosRotBuilder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PosRot)) {
                return false;
            }
            PosRot other = (PosRot)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (Float.compare(this.yaw(), other.yaw()) != 0) {
                return false;
            }
            if (Float.compare(this.pitch(), other.pitch()) != 0) {
                return false;
            }
            Vector3D this$delta = this.delta();
            Vector3D other$delta = other.delta();
            return !(this$delta == null ? other$delta != null : !((Object)this$delta).equals(other$delta));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PosRot;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + Float.floatToIntBits(this.yaw());
            result = result * 59 + Float.floatToIntBits(this.pitch());
            Vector3D $delta = this.delta();
            result = result * 59 + ($delta == null ? 43 : ((Object)$delta).hashCode());
            return result;
        }

        @NotNull
        @Generated
        public Vector3D delta() {
            return this.delta;
        }

        @Generated
        public float yaw() {
            return this.yaw;
        }

        @Generated
        public float pitch() {
            return this.pitch;
        }

        @Override
        @Generated
        public String toString() {
            return "ClientboundMoveEntityPacket.PosRot(super=" + super.toString() + ", delta=" + String.valueOf(this.delta()) + ", yaw=" + this.yaw() + ", pitch=" + this.pitch() + ")";
        }

        @Generated
        public static class PosRotBuilder {
            @Generated
            private int entityId;
            @Generated
            private boolean onGround;
            @Generated
            private Vector3D delta;
            @Generated
            private float yaw;
            @Generated
            private float pitch;

            @Generated
            PosRotBuilder() {
            }

            @Generated
            public PosRotBuilder entityId(int entityId) {
                this.entityId = entityId;
                return this;
            }

            @Generated
            public PosRotBuilder onGround(boolean onGround) {
                this.onGround = onGround;
                return this;
            }

            @Generated
            public PosRotBuilder delta(@NotNull Vector3D delta) {
                if (delta == null) {
                    throw new NullPointerException("delta is marked non-null but is null");
                }
                this.delta = delta;
                return this;
            }

            @Generated
            public PosRotBuilder yaw(float yaw) {
                this.yaw = yaw;
                return this;
            }

            @Generated
            public PosRotBuilder pitch(float pitch) {
                this.pitch = pitch;
                return this;
            }

            @Generated
            public PosRot build() {
                return new PosRot(this.entityId, this.onGround, this.delta, this.yaw, this.pitch);
            }

            @Generated
            public String toString() {
                return "ClientboundMoveEntityPacket.PosRot.PosRotBuilder(entityId=" + this.entityId + ", onGround=" + this.onGround + ", delta=" + String.valueOf(this.delta) + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ")";
            }
        }
    }
}

