/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.sl;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.slot.EquipmentSlotRegistry;
import sba.sl.sl.EquipmentSlotGroup;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface EquipmentSlot
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @NotNull
    public EquipmentSlotGroup asGroup();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.EQUIPMENT_SLOT) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static EquipmentSlot of(@MinecraftType(value=MinecraftType.Type.EQUIPMENT_SLOT) @NotNull Object slot) {
        EquipmentSlot result = EquipmentSlot.ofNullable(slot);
        Preconditions.checkNotNullIllegal(result, "Could not find equipment slot: " + String.valueOf(slot));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static EquipmentSlot ofNullable(@MinecraftType(value=MinecraftType.Type.EQUIPMENT_SLOT) @Nullable Object slot) {
        if (slot instanceof EquipmentSlot) {
            return (EquipmentSlot)slot;
        }
        return (EquipmentSlot)EquipmentSlotRegistry.getInstance().resolveMapping(slot);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull EquipmentSlot> all() {
        return EquipmentSlotRegistry.getInstance().getRegistryItemStream();
    }
}

