/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.audience;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.spectator.Book;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.spectator.TitleableAudienceComponentLike;
import sba.sl.spectator.audience.Audience;
import sba.sl.spectator.audience.adapter.PlayerAdapter;
import sba.sl.spectator.bossbar.BossBar;
import sba.sl.spectator.sound.SoundStart;
import sba.sl.spectator.sound.SoundStop;
import sba.sl.spectator.title.TimesProvider;
import sba.sl.spectator.title.Title;

public interface PlayerAudience
extends Audience {
    public void sendActionBar(@NotNull ComponentLike var1);

    default public void sendRichActionBar(@NotNull String message) {
        this.sendActionBar(Component.fromMiniMessage(message));
    }

    default public void sendPlainActionBar(@NotNull String message) {
        this.sendActionBar(Component.text(message));
    }

    default public void sendPlainActionBar(@NotNull String message, @NotNull Color color) {
        this.sendActionBar(Component.text(message, color));
    }

    default public void sendPlayerListHeader(@NotNull ComponentLike header) {
        this.sendPlayerListHeaderFooter(header, Component.empty());
    }

    default public void sendRichPlayerListHeader(@NotNull String header) {
        this.sendPlayerListHeaderFooter(Component.fromMiniMessage(header), Component.empty());
    }

    default public void sendPlainPlayerListHeader(@NotNull String header) {
        this.sendPlayerListHeaderFooter(Component.text(header), Component.empty());
    }

    default public void sendPlainPlayerListHeader(@NotNull String header, @NotNull Color color) {
        this.sendPlayerListHeaderFooter(Component.text(header, color), Component.empty());
    }

    default public void sendPlayerListFooter(@NotNull ComponentLike footer) {
        this.sendPlayerListHeaderFooter(Component.empty(), footer);
    }

    default public void sendRichPlayerListFooter(@NotNull String footer) {
        this.sendPlayerListHeaderFooter(Component.empty(), Component.fromMiniMessage(footer));
    }

    default public void sendPlainPlayerListFooter(@NotNull String footer) {
        this.sendPlayerListHeaderFooter(Component.empty(), Component.text(footer));
    }

    default public void sendPlainPlayerListFooter(@NotNull String footer, @NotNull Color color) {
        this.sendPlayerListHeaderFooter(Component.empty(), Component.text(footer, color));
    }

    public void sendPlayerListHeaderFooter(@NotNull ComponentLike var1, @NotNull ComponentLike var2);

    default public void sendRichPlayerListHeaderFooter(@NotNull String header, @NotNull String footer) {
        this.sendPlayerListHeaderFooter(Component.fromMiniMessage(header), Component.fromMiniMessage(footer));
    }

    default public void sendPlainPlayerListHeaderFooter(@NotNull String header, @NotNull String footer) {
        this.sendPlayerListHeaderFooter(Component.text(header), Component.text(footer));
    }

    default public void sendPlainPlayerListHeaderFooter(@NotNull String header, @NotNull String footer, @NotNull Color color) {
        this.sendPlayerListHeaderFooter(Component.text(header, color), Component.text(footer, color));
    }

    default public void sendPlainPlayerListHeaderFooter(@NotNull String header, @NotNull Color headerColor, @NotNull String footer, @NotNull Color footerColor) {
        this.sendPlayerListHeaderFooter(Component.text(header, headerColor), Component.text(footer, footerColor));
    }

    default public void showTitle(@NotNull Title.Builder title) {
        this.showTitle(title.build());
    }

    default public void showTitle(@NotNull TitleableAudienceComponentLike title) {
        this.showTitle(title, null);
    }

    public void showTitle(@NotNull TitleableAudienceComponentLike var1, @Nullable TimesProvider var2);

    public void showTitle(@NotNull Title var1);

    public void clearTitle();

    public void showBossBar(@NotNull BossBar var1);

    public void hideBossBar(@NotNull BossBar var1);

    default public void playSound(@NotNull SoundStart.Builder sound) {
        this.playSound(sound.build());
    }

    public void playSound(@NotNull SoundStart var1);

    default public void playSound(@NotNull SoundStart.Builder sound, double x, double y, double z) {
        this.playSound(sound.build(), x, y, z);
    }

    public void playSound(@NotNull SoundStart var1, double var2, double var4, double var6);

    default public void stopSound(@NotNull SoundStart.Builder sound) {
        this.stopSound(sound.build());
    }

    default public void stopSound(@NotNull SoundStart sound) {
        this.stopSound(SoundStop.namedSourced(sound.soundKey(), sound.source()));
    }

    default public void stopSound(@NotNull SoundStop.Builder sound) {
        this.stopSound(sound.build());
    }

    public void stopSound(@NotNull SoundStop var1);

    default public void openBook(@NotNull Book.Builder book) {
        this.openBook(book.build());
    }

    public void openBook(@NotNull Book var1);

    @FunctionalInterface
    @ApiStatus.NonExtendable
    public static interface ForwardingToAdapter
    extends PlayerAudience,
    Audience.ForwardingToAdapter {
        @Override
        @ApiStatus.OverrideOnly
        @NotNull
        public PlayerAdapter adapter();

        @Override
        default public void sendActionBar(@NotNull ComponentLike message) {
            this.adapter().sendActionBar(message);
        }

        @Override
        default public void sendPlayerListHeaderFooter(@NotNull ComponentLike header, @NotNull ComponentLike footer) {
            this.adapter().sendPlayerListHeaderFooter(header, footer);
        }

        @Override
        default public void showTitle(@NotNull Title title) {
            this.adapter().showTitle(title);
        }

        @Override
        default public void showTitle(@NotNull TitleableAudienceComponentLike title, @Nullable TimesProvider times) {
            this.adapter().showTitle(title, times);
        }

        @Override
        default public void clearTitle() {
            this.adapter().clearTitle();
        }

        @Override
        default public void showBossBar(@NotNull BossBar bossBar) {
            this.adapter().showBossBar(bossBar);
        }

        @Override
        default public void hideBossBar(@NotNull BossBar bossBar) {
            this.adapter().hideBossBar(bossBar);
        }

        @Override
        default public void playSound(@NotNull SoundStart sound) {
            this.adapter().playSound(sound);
        }

        @Override
        default public void playSound(@NotNull SoundStart sound, double x, double y, double z) {
            this.adapter().playSound(sound, x, y, z);
        }

        @Override
        default public void stopSound(@NotNull SoundStop sound) {
            this.adapter().stopSound(sound);
        }

        @Override
        default public void openBook(@NotNull Book book) {
            this.adapter().openBook(book);
        }
    }

    @FunctionalInterface
    public static interface ForwardingToSingle
    extends PlayerAudience,
    Audience.ForwardingToSingle {
        @Override
        @ApiStatus.OverrideOnly
        @NotNull
        public PlayerAudience audience();

        @Override
        default public void sendActionBar(@NotNull ComponentLike message) {
            this.audience().sendActionBar(message);
        }

        @Override
        default public void sendPlayerListHeaderFooter(@NotNull ComponentLike header, @NotNull ComponentLike footer) {
            this.audience().sendPlayerListHeaderFooter(header, footer);
        }

        @Override
        default public void showTitle(@NotNull Title title) {
            this.audience().showTitle(title);
        }

        @Override
        default public void showTitle(@NotNull TitleableAudienceComponentLike title, @Nullable TimesProvider times) {
            this.audience().showTitle(title, times);
        }

        @Override
        default public void clearTitle() {
            this.audience().clearTitle();
        }

        @Override
        default public void showBossBar(@NotNull BossBar bossBar) {
            this.audience().showBossBar(bossBar);
        }

        @Override
        default public void hideBossBar(@NotNull BossBar bossBar) {
            this.audience().hideBossBar(bossBar);
        }

        @Override
        default public void playSound(@NotNull SoundStart sound) {
            this.audience().playSound(sound);
        }

        @Override
        default public void playSound(@NotNull SoundStart sound, double x, double y, double z) {
            this.audience().playSound(sound, x, y, z);
        }

        @Override
        default public void stopSound(@NotNull SoundStop sound) {
            this.audience().stopSound(sound);
        }

        @Override
        default public void openBook(@NotNull Book book) {
            this.audience().openBook(book);
        }
    }

    @FunctionalInterface
    public static interface ForwardingToMulti
    extends PlayerAudience,
    Audience.ForwardingToMulti {
        @ApiStatus.OverrideOnly
        @NotNull
        public @NotNull Iterable<? extends @NotNull PlayerAudience> audiences();

        @Override
        default public void sendActionBar(@NotNull ComponentLike message) {
            this.audiences().forEach(audience -> audience.sendActionBar(message));
        }

        @Override
        default public void sendPlayerListHeaderFooter(@NotNull ComponentLike header, @NotNull ComponentLike footer) {
            this.audiences().forEach(audience -> audience.sendPlayerListHeaderFooter(header, footer));
        }

        @Override
        default public void showTitle(@NotNull Title title) {
            this.audiences().forEach(audience -> audience.showTitle(title));
        }

        @Override
        default public void showTitle(@NotNull TitleableAudienceComponentLike title, @Nullable TimesProvider times) {
            this.audiences().forEach(audience -> audience.showTitle(title, times));
        }

        @Override
        default public void clearTitle() {
            this.audiences().forEach(PlayerAudience::clearTitle);
        }

        @Override
        default public void showBossBar(@NotNull BossBar bossBar) {
            this.audiences().forEach(audience -> audience.showBossBar(bossBar));
        }

        @Override
        default public void hideBossBar(@NotNull BossBar bossBar) {
            this.audiences().forEach(audience -> audience.hideBossBar(bossBar));
        }

        @Override
        default public void playSound(@NotNull SoundStart sound) {
            this.audiences().forEach(audience -> audience.playSound(sound));
        }

        @Override
        default public void playSound(@NotNull SoundStart sound, double x, double y, double z) {
            this.audiences().forEach(audience -> audience.playSound(sound, x, y, z));
        }

        @Override
        default public void stopSound(@NotNull SoundStop sound) {
            this.audiences().forEach(audience -> audience.stopSound(sound));
        }

        @Override
        default public void openBook(@NotNull Book book) {
            this.audiences().forEach(audience -> audience.openBook(book));
        }
    }
}

