/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.event;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import sba.sl.api.Wrapper;
import sba.sl.impl.spectator.Spectator;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.spectator.event.hover.Content;
import sba.sl.spectator.event.hover.ContentLike;
import sba.sl.spectator.event.hover.EntityContent;
import sba.sl.spectator.event.hover.EntityContentLike;
import sba.sl.spectator.event.hover.ItemContent;
import sba.sl.spectator.event.hover.ItemContentLike;
import sba.sl.u.RawValueHolder;

public interface HoverEvent
extends Wrapper,
RawValueHolder {
    @Contract(value="-> new", pure=true)
    public static @NotNull Builder builder() {
        return Spectator.getBackend().hoverEvent();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static HoverEvent showText(@NotNull Component text) {
        return Spectator.getBackend().hoverEvent().action(Action.SHOW_TEXT).content(text).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static HoverEvent showText(@NotNull ComponentLike text) {
        return Spectator.getBackend().hoverEvent().action(Action.SHOW_TEXT).content(text).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static HoverEvent showItem(@NotNull ItemContent itemContent) {
        return Spectator.getBackend().hoverEvent().action(Action.SHOW_ITEM).content(itemContent).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static HoverEvent showItem(@NotNull ItemContentLike itemContent) {
        return Spectator.getBackend().hoverEvent().action(Action.SHOW_ITEM).content(itemContent).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static HoverEvent showEntity(@NotNull EntityContent itemContent) {
        return Spectator.getBackend().hoverEvent().action(Action.SHOW_ENTITY).content(itemContent).build();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static HoverEvent showEntity(@NotNull EntityContentLike itemContent) {
        return Spectator.getBackend().hoverEvent().action(Action.SHOW_ENTITY).content(itemContent).build();
    }

    @NotNull
    public Action action();

    @NotNull
    public Content content();

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder action(@NotNull Action var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder content(@NotNull Content var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder content(@NotNull ContentLike contentLike) {
            return this.content(contentLike.asContent());
        }

        @Contract(value="-> new", pure=true)
        @NotNull
        public HoverEvent build();
    }

    public static enum Action {
        SHOW_TEXT,
        SHOW_ITEM,
        SHOW_ENTITY;

    }
}

