/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.placeholders;

import java.util.List;
import java.util.function.BooleanSupplier;
import lombok.Generated;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import sba.sl.spectator.Component;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.mini.placeholders.StringLikePlaceholder;

public abstract class BooleanPlaceholder
implements Placeholder,
StringLikePlaceholder {
    @Pattern(value="[a-z\\d_-]+")
    @NotNull
    private final String name;

    public abstract boolean isValue();

    @Override
    @NotNull
    public <B extends Component.Builder<B, C>, C extends Component> B getResult(@NotNull MiniMessageParser parser, @NotNull @NotNull List<@NotNull String> arguments, Placeholder ... placeholders) {
        boolean value = this.isValue();
        if (arguments.size() == 2) {
            if (value) {
                return parser.parseIntoBuilder(arguments.get(0), placeholders);
            }
            return parser.parseIntoBuilder(arguments.get(1), placeholders);
        }
        return (B)Component.text().content(value);
    }

    @Override
    @NotNull
    public String getStringResult(@NotNull MiniMessageParser parser, @NotNull @NotNull List<@NotNull String> arguments, Placeholder ... placeholders) {
        boolean value = this.isValue();
        if (arguments.size() == 2) {
            if (value) {
                return parser.resolvePlaceholdersInString(arguments.get(0), placeholders);
            }
            return parser.resolvePlaceholdersInString(arguments.get(1), placeholders);
        }
        return String.valueOf(value);
    }

    @Generated
    public BooleanPlaceholder(@NotNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Override
    @NotNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BooleanPlaceholder)) {
            return false;
        }
        BooleanPlaceholder other = (BooleanPlaceholder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BooleanPlaceholder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BooleanPlaceholder(name=" + this.getName() + ")";
    }

    public static final class Lazy
    extends BooleanPlaceholder {
        @NotNull
        private final BooleanSupplier supplier;

        public Lazy(@Pattern(value="[a-z\\d_-]+") @NotNull String name, @NotNull BooleanSupplier supplier) {
            super(name);
            this.supplier = supplier;
        }

        @Override
        public boolean isValue() {
            return this.supplier.getAsBoolean();
        }

        @NotNull
        @Generated
        public BooleanSupplier getSupplier() {
            return this.supplier;
        }
    }

    public static final class Constant
    extends BooleanPlaceholder {
        private final boolean value;

        public Constant(@Pattern(value="[a-z\\d_-]+") @NotNull String name, boolean value) {
            super(name);
            this.value = value;
        }

        @Override
        @Generated
        public boolean isValue() {
            return this.value;
        }
    }
}

