/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.vi;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import sba.sl.ev.EventExecutionOrder;
import sba.sl.ev.OnEvent;
import sba.sl.ev.player.PlayerLeaveEvent;
import sba.sl.ev.player.PlayerMoveEvent;
import sba.sl.ev.player.PlayerRespawnEvent;
import sba.sl.ev.player.PlayerTeleportEvent;
import sba.sl.ev.player.PlayerWorldChangeEvent;
import sba.sl.p.event.SPlayerServerboundInteractEvent;
import sba.sl.pa.Player;
import sba.sl.t.DefaultThreads;
import sba.sl.t.Tasker;
import sba.sl.t.TaskerTime;
import sba.sl.u.InteractType;
import sba.sl.u.annotations.methods.OnPreDisable;
import sba.sl.vi.TouchableVisual;
import sba.sl.vi.Visual;
import sba.sl.w.Location;
import sba.sl.w.World;

public abstract class AbstractVisualsManager<T extends TouchableVisual<T>> {
    @NotNull
    protected final @NotNull Map<@NotNull UUID, T> activeVisuals = new HashMap<UUID, T>();
    @NotNull
    private final @NotNull Map<@NotNull UUID, Long> coolDownMap = new HashMap<UUID, Long>();

    public void addVisual(@NotNull UUID uuid, @NotNull T visual) {
        this.activeVisuals.put(uuid, visual);
    }

    public void removeVisual(@NotNull T visual) {
        this.removeVisual(visual.uuid());
    }

    public void removeVisual(@NotNull UUID uuid) {
        this.activeVisuals.remove(uuid);
    }

    @NotNull
    public @NotNull Map<@NotNull UUID, T> getActiveVisuals() {
        return Map.copyOf(this.activeVisuals);
    }

    @OnPreDisable
    public void destroy() {
        List<TouchableVisual> visualCopy = List.copyOf(this.getActiveVisuals().values());
        visualCopy.forEach(Visual::destroy);
        this.activeVisuals.clear();
        this.coolDownMap.clear();
    }

    @OnEvent
    public void onLeave(@NotNull PlayerLeaveEvent event) {
        this.coolDownMap.remove(event.player().getUuid());
        if (this.activeVisuals.isEmpty()) {
            return;
        }
        Player player = event.player();
        for (Map.Entry<UUID, T> entry : this.activeVisuals.entrySet()) {
            TouchableVisual visual = (TouchableVisual)entry.getValue();
            if (!visual.viewers().contains(player)) continue;
            visual.removeViewer(player);
        }
    }

    @OnEvent
    public void onMove(@NotNull PlayerMoveEvent event) {
        if (this.activeVisuals.isEmpty()) {
            return;
        }
        Player player = event.player();
        Location newLocation = event.newLocation();
        Location oldLocation = event.currentLocation();
        for (TouchableVisual visual : this.activeVisuals.values()) {
            if (!visual.hasViewers()) continue;
            Location visualLocation = visual.location();
            int viewDistance = visual.viewDistance();
            if (!visual.viewers().contains(player) || !visualLocation.isWorldSame(newLocation)) continue;
            if (newLocation.isInRange(visualLocation, viewDistance) && oldLocation.outOfRange(visualLocation, viewDistance)) {
                visual.onViewerAdded(player, false);
                continue;
            }
            if (!newLocation.outOfRange(visualLocation, viewDistance) || !oldLocation.isInRange(visualLocation, viewDistance)) continue;
            visual.onViewerRemoved(player, false);
        }
    }

    @OnEvent(order=EventExecutionOrder.MONITOR)
    public void onRespawn(@NotNull PlayerRespawnEvent event) {
        if (this.activeVisuals.isEmpty()) {
            return;
        }
        Player player = event.player();
        Location respawnLocation = event.location();
        for (TouchableVisual visual : this.activeVisuals.values()) {
            if (!visual.hasViewers()) continue;
            Collection<Player> viewers = visual.viewers();
            Location visualLocation = visual.location();
            int viewDistance = visual.viewDistance();
            if (!viewers.contains(player)) continue;
            if (!respawnLocation.isWorldSame(visualLocation)) {
                return;
            }
            if (!respawnLocation.isInRange(visualLocation, viewDistance)) continue;
            this.softAddViewer(visual, player, 20L);
        }
    }

    @OnEvent
    public void onWorldChange(@NotNull PlayerWorldChangeEvent event) {
        if (this.activeVisuals.isEmpty()) {
            return;
        }
        Player player = event.player();
        World from = event.from();
        for (TouchableVisual visual : this.activeVisuals.values()) {
            if (!visual.hasViewers()) continue;
            Collection<Player> viewers = visual.viewers();
            Location visualLocation = visual.location();
            int viewDistance = visual.viewDistance();
            if (!viewers.contains(player) || !player.getLocation().isWorldSame(visualLocation) || from.equals(visualLocation.getWorld()) || !player.getLocation().isInRange(visualLocation, viewDistance)) continue;
            this.softAddViewer(visual, player, 1L);
        }
    }

    @OnEvent
    public void onTeleport(@NotNull PlayerTeleportEvent event) {
        Location newLocation;
        if (this.activeVisuals.isEmpty()) {
            return;
        }
        Location currentLocation = event.currentLocation();
        if (!currentLocation.isWorldSame(newLocation = event.newLocation())) {
            return;
        }
        Player player = event.player();
        for (TouchableVisual visual : this.activeVisuals.values()) {
            Location visualLocation;
            Collection<Player> viewers;
            if (!visual.hasViewers() || !(viewers = visual.viewers()).contains(player) || !(visualLocation = visual.location()).isWorldSame(player.getLocation())) continue;
            int viewDistance = visual.viewDistance();
            if (newLocation.isInRange(visualLocation, viewDistance) && currentLocation.outOfRange(visualLocation, viewDistance)) {
                this.softAddViewer(visual, player, 20L);
                continue;
            }
            if (!newLocation.outOfRange(visualLocation, viewDistance) || !currentLocation.isInRange(visualLocation, viewDistance)) continue;
            this.softRemoveViewer(visual, player, 20L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnEvent
    public void onInteract(@NotNull SPlayerServerboundInteractEvent event) {
        Player player = event.getPlayer();
        int entityId = event.getEntityId();
        for (Map.Entry<UUID, T> entry : this.activeVisuals.entrySet()) {
            TouchableVisual visual = (TouchableVisual)entry.getValue();
            if (!visual.hasId(entityId) || !visual.touchable()) continue;
            Map<UUID, Long> map = this.coolDownMap;
            synchronized (map) {
                if (this.coolDownMap.containsKey(player.getUuid())) {
                    Long lastClick = this.coolDownMap.get(player.getUuid());
                    if (System.currentTimeMillis() - lastClick < visual.clickCooldown()) {
                        break;
                    }
                }
                this.coolDownMap.put(player.getUuid(), System.currentTimeMillis());
            }
            Tasker.run(DefaultThreads.GLOBAL_THREAD, () -> this.fireVisualTouchEvent(player, visual, event.getInteractType()));
            break;
        }
    }

    private void softAddViewer(@NotNull T visual, @NotNull Player player, long tickedDelay) {
        Tasker.runAsyncDelayed(() -> {
            if (!player.isOnline()) {
                return;
            }
            visual.onViewerAdded(player, false);
        }, tickedDelay, TaskerTime.TICKS);
    }

    private void softRemoveViewer(@NotNull T visual, @NotNull Player player, long tickedDelay) {
        Tasker.runAsyncDelayed(() -> {
            if (!player.isOnline()) {
                return;
            }
            visual.onViewerRemoved(player, false);
        }, tickedDelay, TaskerTime.TICKS);
    }

    public abstract void fireVisualTouchEvent(@NotNull Player var1, @NotNull T var2, @NotNull InteractType var3);
}

