/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.w.difficulty;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.world.difficulty.DifficultyRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface DifficultyType
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.DIFFICULTY_TYPE) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static DifficultyType of(@MinecraftType(value=MinecraftType.Type.DIFFICULTY_TYPE) @NotNull Object difficulty) {
        DifficultyType result = DifficultyType.ofNullable(difficulty);
        Preconditions.checkNotNullIllegal(result, "Could not find difficulty: " + String.valueOf(difficulty));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static DifficultyType ofNullable(@MinecraftType(value=MinecraftType.Type.DIFFICULTY_TYPE) @Nullable Object difficulty) {
        if (difficulty instanceof DifficultyType) {
            return (DifficultyType)difficulty;
        }
        return (DifficultyType)DifficultyRegistry.getInstance().resolveMapping(difficulty);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull DifficultyType> all() {
        return DifficultyRegistry.getInstance().getRegistryItemStream();
    }
}

