/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board;

import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board.ConfigBoard;
import java.util.Collection;
import java.util.HashMap;
import org.bukkit.entity.Player;

public class BoardPlayer {
    private final Player player;
    private ConfigBoard configBoard;
    private boolean enabled = true;
    public boolean worldLock = false;
    private static HashMap<Player, BoardPlayer> map = new HashMap();

    private BoardPlayer(Player player) {
        this.player = player;
        map.put(player, this);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!this.enabled) {
            this.configBoard.unhookPlayer(this.player);
        } else {
            this.configBoard.hookPlayer(this.player);
        }
    }

    public void lock() {
        this.configBoard.unhookPlayer(this.player);
        this.worldLock = true;
    }

    public void unlock() {
        this.worldLock = false;
        if (this.isEnabled()) {
            this.configBoard.hookPlayer(this.player);
        }
    }

    public void attachConfigBoard(ConfigBoard board) {
        if (this.configBoard != null) {
            this.configBoard.unhookPlayer(this.player);
        }
        this.configBoard = board;
        this.configBoard.hookPlayer(this.player);
    }

    public void kill() {
        this.configBoard.unhookPlayer(this.player);
        map.remove(this.player);
    }

    public static BoardPlayer getBoardPlayer(Player player) {
        if (map.containsKey(player)) {
            return map.get(player);
        }
        return new BoardPlayer(player);
    }

    public static Collection<BoardPlayer> allBoardPlayers() {
        return map.values();
    }

    public static BoardPlayer getBoardPlayerOrNull(Player player) {
        return map.get(player);
    }
}

