/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board;

import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board.animations.Row;
import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board.implementations.WrapperBoard;
import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.plugin.utility.ScoreboardStrings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class ConfigBoard
extends BukkitRunnable {
    public String board;
    private String objectiveName = "";
    private Row title;
    private ArrayList<Row> rows = new ArrayList();
    private ArrayList<Player> players = new ArrayList();
    private HashMap<Player, WrapperBoard> playerToBoard = new HashMap();
    private boolean enabled;

    public ConfigBoard(String board) {
        this.board = board;
        this.enabled = true;
        this.initTitle();
        this.initRows();
    }

    public void setObjective(String objectiveName) {
        this.objectiveName = objectiveName;
    }

    public void setTitle(List<String> animation, long interval) {
        this.title = new Row(ScoreboardStrings.makeColoredStringList(animation), (int)interval);
    }

    private void initTitle() {
        this.title = new Row(ScoreboardStrings.makeColoredStringList(List.of()), 0);
    }

    private void initRows() {
    }

    public void setLines(List<String> lines) {
        for (int i = 0; i < lines.size() && i < this.rows.size(); ++i) {
            this.rows.set(i, new Row(ScoreboardStrings.makeColoredStringList(List.of(lines.get(i))), 0));
        }
        while (this.rows.size() < lines.size()) {
            this.rows.add(new Row(ScoreboardStrings.makeColoredStringList(List.of(lines.get(this.rows.size()))), 0));
        }
        while (this.rows.size() > lines.size()) {
            this.rows.remove(this.rows.size() - 1);
        }
    }

    public void hookPlayer(Player player) {
        this.players.add(player);
        try {
            WrapperBoard wrapperBoard = new WrapperBoard("SCOREBOARD_DRIVER_V1");
            wrapperBoard.setObjective(this.objectiveName);
            wrapperBoard.setLineCount(this.rows.size());
            wrapperBoard.setPlayer(player);
            this.playerToBoard.put(player, wrapperBoard);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public void unhookPlayer(Player player) {
        this.playerToBoard.remove(player);
        this.players.remove(player);
        player.setScoreboard(Objects.requireNonNull(Bukkit.getScoreboardManager()).getNewScoreboard());
    }

    public void run() {
        if (!this.enabled) {
            return;
        }
        this.title.update();
        for (Row row : this.rows) {
            row.update();
        }
        for (Player player : this.playerToBoard.keySet()) {
            WrapperBoard wrapperBoard = this.playerToBoard.get(player);
            wrapperBoard.setTitle(this.title.getLine());
            wrapperBoard.setLineCount(this.rows.size());
            int count = 0;
            for (Row row : new ArrayList<Row>(this.rows)) {
                wrapperBoard.setLine(count, row.getLine());
                ++count;
            }
        }
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    @Nullable
    public WrapperBoard of(Player p) {
        return this.playerToBoard.get(p);
    }
}

