/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.utils.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Scanner;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import sba.sl.pu.ServiceManager;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnPostEnable;
import sba.sl.u.reflect.Reflect;

@Service
@ServiceDependencies(dependsOn={SBAConfig.class})
public class UpdateChecker {
    private static final String GITEA_API = "https://gitea.moyskleytech.com/api/v1/repos/boiscljo/SBA/releases";
    private String version;
    private boolean isPendingUpdate = false;
    private JavaPlugin plugin;
    private String downloadUrl;

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public static UpdateChecker getInstance() {
        return ServiceManager.get(UpdateChecker.class);
    }

    @OnPostEnable
    public void checkForUpdates() {
        if (SBA.isBroken()) {
            return;
        }
        if (SBA.getInstance().isSnapshot()) {
            return;
        }
        if (!SBAConfig.getInstance().shouldCheckUpdate()) {
            return;
        }
        new Thread(() -> {
            try {
                String[] entries;
                HttpURLConnection connection = (HttpURLConnection)new URL(GITEA_API).openConnection();
                connection.setRequestProperty("User-Agent", "SBA-Updater");
                connection.setRequestMethod("GET");
                StringBuilder jsonBuilder = new StringBuilder();
                try (Scanner scanner = new Scanner(connection.getInputStream());){
                    while (scanner.hasNextLine()) {
                        jsonBuilder.append(scanner.nextLine());
                    }
                }
                String json = jsonBuilder.toString();
                for (String entry : entries = json.split("\\{")) {
                    if (!entry.contains("\"prerelease\":false") || !entry.contains("\"draft\":false")) continue;
                    int tagStart = entry.indexOf("\"tag_name\":\"") + 12;
                    int tagEnd = entry.indexOf("\"", tagStart);
                    this.version = entry.substring(tagStart, tagEnd);
                    int urlStart = entry.indexOf("\"browser_download_url\":\"") + 25;
                    int urlEnd = entry.indexOf("\"", urlStart);
                    this.downloadUrl = entry.substring(urlStart, urlEnd);
                    break;
                }
                if (this.version != null && !this.version.equalsIgnoreCase(SBA.getInstance().getVersion())) {
                    this.promptUpdate(this.version);
                } else {
                    Bukkit.getLogger().info("No updates found");
                }
            }
            catch (Exception e) {
                Logger.error("Failed to check for updates: {}", e);
            }
        }).start();
    }

    private void promptUpdate(@NotNull String version) {
        this.version = version;
        this.isPendingUpdate = true;
        if (SBAConfig.getInstance().shouldWarnConsoleAboutUpdate()) {
            Bukkit.getLogger().info("\u00a7e\u00a7lTHERE IS A NEW UPDATE AVAILABLE Version: " + version);
            Bukkit.getLogger().info("Download it from here: " + this.downloadUrl + " or run \u00a7e/sba updateplugin");
        }
    }

    public void sendToUser(@NotNull Player player) {
        player.sendMessage("[SBA] \u00a7eTHERE IS A NEW UPDATE AVAILABLE Version: " + this.version);
        player.sendMessage("Download it from here: " + this.downloadUrl + " or run \u00a7e/sba updateplugin");
    }

    public void update(final @NotNull CommandSender sender) {
        if (!this.isPendingUpdate || this.downloadUrl == null) {
            sender.sendMessage("No update available.");
            return;
        }
        new BukkitRunnable(){

            public void run() {
                try {
                    int grab;
                    HttpURLConnection httpConnection = (HttpURLConnection)new URL(UpdateChecker.this.downloadUrl).openConnection();
                    httpConnection.setRequestProperty("User-Agent", "SBA-Updater");
                    int grabSize = 2048;
                    BufferedInputStream in = new BufferedInputStream(httpConnection.getInputStream());
                    File pluginFile = (File)Reflect.fastInvoke((Object)UpdateChecker.this.plugin, "getFile");
                    FileOutputStream fos = new FileOutputStream(pluginFile);
                    BufferedOutputStream bout = new BufferedOutputStream(fos, grabSize);
                    byte[] data = new byte[grabSize];
                    while ((grab = in.read(data, 0, grabSize)) >= 0) {
                        bout.write(data, 0, grab);
                    }
                    bout.close();
                    in.close();
                    fos.close();
                    sender.sendMessage("Plugin JAR updated, please restart your server to receive the update.");
                    Bukkit.getServer().shutdown();
                }
                catch (Exception ex) {
                    Logger.error("Error occurred while updating: {}", ex);
                    sender.sendMessage("Update failed: " + ex.getMessage());
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public boolean isPendingUpdate() {
        return this.isPendingUpdate;
    }
}

