/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBAPlayerPartyInviteEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import sba.cl.annotations.Argument;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.CommandPermission;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class PartyInviteCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        if (init) {
            return;
        }
        if (SBAConfig.getInstance().party().enabled()) {
            CommandManager.getInstance().getAnnotationParser().parse(this);
        }
        init = true;
    }

    @CommandMethod(value="party|p <invitee>")
    @CommandPermission(value="sba.party")
    private void commandInviteWithout(@NotNull Player playerArg, @Argument(value="invitee") @NotNull Player invitee) {
        this.commandInvite(playerArg, invitee);
    }

    @CommandMethod(value="party|p invite <invitee>")
    @CommandPermission(value="sba.party")
    private void commandInvite(@NotNull Player playerArg, @Argument(value="invitee") @NotNull Player invitee) {
        SBAPlayerWrapper player;
        SBAPlayerWrapper invitedPlayer = SBA.getInstance().getPlayerWrapper(invitee);
        if (invitedPlayer.equals(player = SBA.getInstance().getPlayerWrapper(playerArg))) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_CANNOT_INVITE_YOURSELF).send(player);
            return;
        }
        if (invitedPlayer.getSettings().isToggled(PlayerSetting.INVITED_TO_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ALREADY_INVITED).send(player);
            return;
        }
        if (invitedPlayer.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_CANNOT_INVITE).send(player);
            return;
        }
        PartyManager.getInstance().getOrCreate(player).ifPresent(party -> {
            if (party.getInvitedPlayers().size() > 5) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_MAX_INVITE_SIZE_REACHED).send(player);
                return;
            }
            if (party.getMembers().size() + party.getInvitedPlayers().size() > SBAConfig.getInstance().getInt("party.size", 4)) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_MAX_INVITE_SIZE_REACHED).send(player);
                return;
            }
            SBAPlayerPartyInviteEvent inviteEvent = new SBAPlayerPartyInviteEvent(player, invitedPlayer);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)inviteEvent);
            if (inviteEvent.isCancelled()) {
                return;
            }
            party.invitePlayer(invitedPlayer, player);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_INVITE_SENT).replace("%player%", invitedPlayer.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).send(player);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_INVITE_RECEIVED).replace("%player%", player.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).send(invitedPlayer);
        });
    }
}

