/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBAPlayerPartyPromoteEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import sba.cl.annotations.Argument;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.CommandPermission;
import sba.sl.pa.ExtendablePlayer;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class PartyPromoteCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnable() {
        if (SBA.isBroken()) {
            return;
        }
        if (init) {
            return;
        }
        CommandManager.getInstance().getManager().getParserRegistry().registerSuggestionProvider("promote", (ctx, s) -> {
            Optional<IParty> optionalParty = PartyManager.getInstance().getPartyOf(SBA.getInstance().getPlayerWrapper((Player)ctx.getSender()));
            if (optionalParty.isEmpty()) {
                return List.of();
            }
            return optionalParty.get().getMembers().stream().map(ExtendablePlayer::getName).collect(Collectors.toList());
        });
        if (SBAConfig.getInstance().party().enabled()) {
            CommandManager.getInstance().getAnnotationParser().parse(this);
        }
        init = true;
    }

    @CommandMethod(value="party|p promote <player>")
    @CommandPermission(value="sba.party")
    private void commandPromote(@NotNull Player playerArg, @Argument(value="player", suggestions="promote") @NotNull Player toPromote) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        SBAPlayerWrapper args = SBA.getInstance().getPlayerWrapper(toPromote);
        if (!player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_IN_PARTY).send(player);
            return;
        }
        SBA.getInstance().getPartyManager().getPartyOf(player).ifPresentOrElse(party -> {
            if (!party.getPartyLeader().equals(player)) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(player);
                return;
            }
            SBAPlayerPartyPromoteEvent partyPromoteEvent = new SBAPlayerPartyPromoteEvent(player, args);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)partyPromoteEvent);
            if (partyPromoteEvent.isCancelled()) {
                return;
            }
            party.setPartyLeader(args);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_PROMOTED_LEADER).replace("%player%", args.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).send(party.getMembers().toArray(new SBAPlayerWrapper[0]));
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR).send(player));
    }
}

