/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.inventories;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBAGamesInventoryOpenEvent;
import io.github.pronze.sba.lang.Message;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.ShopUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;
import sba.si.SimpleInventoriesCore;
import sba.si.builder.InventorySetBuilder;
import sba.si.events.PostClickEvent;
import sba.si.inventory.GenericItemInfo;
import sba.si.inventory.Include;
import sba.si.inventory.InventorySet;
import sba.si.inventory.PlayerItemInfo;
import sba.si.inventory.Property;
import sba.si.inventory.SubInventory;
import sba.sl.i.ItemStack;
import sba.sl.pa.Players;
import sba.sl.pu.ServiceManager;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
@ServiceDependencies(dependsOn={SBAConfig.class, SimpleInventoriesCore.class})
public class GamesInventory
implements Listener {
    private static final HashMap<Integer, String> labels = new HashMap<Integer, String>(){
        {
            this.put(1, "solo");
            this.put(2, "double");
            this.put(3, "triples");
            this.put(4, "squads");
        }
    };
    private final HashMap<String, InventorySet> inventoryMap = new HashMap();

    public static GamesInventory getInstance() {
        return ServiceManager.get(GamesInventory.class);
    }

    public List<String> getGameModeNames() {
        return new ArrayList<String>(this.inventoryMap.keySet());
    }

    @OnPostEnable
    public void loadInventory() {
        try {
            Arrays.stream(new File(SBA.getPluginInstance().getDataFolder().getAbsolutePath() + "/games-inventory/").listFiles()).forEach(inventoryFile -> {
                try {
                    String label = inventoryFile.getName().toLowerCase().replace(".yml", "");
                    if (label.equals("npc")) {
                        return;
                    }
                    InventorySet siFormat = ((InventorySetBuilder)((InventorySetBuilder)SimpleInventoriesCore.builder().categoryOptions(localOptionsBuilder -> {
                        ShopUtil.generateOptions(localOptionsBuilder);
                        try {
                            localOptionsBuilder.prefix(LanguageService.getInstance().get("games-inventory", "gui", label.toLowerCase() + "-prefix").toString());
                        }
                        catch (Throwable t) {
                            localOptionsBuilder.prefix(label);
                        }
                    })).call(categoryBuilder -> {
                        try {
                            categoryBuilder.include(Include.of(Paths.get(inventoryFile.getAbsolutePath(), new String[0])));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    })).click(this::onClick).process().getInventorySet();
                    this.inventoryMap.put(label, siFormat);
                    Logger.trace("Successfully loaded games inventory for: {}", inventoryFile.getName());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void openForPlayer(Player player, int mode) {
        SBAGamesInventoryOpenEvent event = new SBAGamesInventoryOpenEvent(player, labels.get(mode));
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        InventorySet format = this.inventoryMap.get(labels.get(mode));
        if (format != null) {
            Players.wrapPlayer(player).openInventory(format);
        }
    }

    public void openForPlayer(Player player, String mode) {
        SBAGamesInventoryOpenEvent event = new SBAGamesInventoryOpenEvent(player, mode);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        InventorySet format = this.inventoryMap.get(mode);
        if (format != null) {
            Players.wrapPlayer(player).openInventory(format);
        }
    }

    public static List<Game> getGamesWithSize(int size) {
        return Main.getGameNames().stream().map(g -> Main.getGame((String)g)).filter(g -> g.getAvailableTeams().stream().allMatch(t -> t.getMaxPlayers() == size)).collect(Collectors.toList());
    }

    public List<Game> getGamesWithMode(String mode) {
        InventorySet invSet = this.inventoryMap.get(mode);
        if (invSet == null) {
            return List.of();
        }
        ArrayList<Game> ret = new ArrayList<Game>();
        SubInventory subInventory = invSet.getMainSubInventory();
        for (GenericItemInfo inventoryParent : subInventory.getContents()) {
            Game game;
            String gameName;
            if (inventoryParent.getChildInventory() != null) {
                for (GenericItemInfo inventoryParent2 : inventoryParent.getChildInventory().getContents()) {
                    Game game2;
                    String gameName2;
                    if (!inventoryParent2.getProperties().stream().anyMatch(x -> x.getPropertyName().equals("join")) || (gameName2 = inventoryParent2.getFirstPropertyByName("join").orElseThrow().getPropertyData().node("gameName").getString()) == null || (game2 = Main.getInstance().getGameByName(gameName2)) == null) continue;
                    ret.add(game2);
                }
            }
            if (!inventoryParent.getProperties().stream().anyMatch(x -> x.getPropertyName().equals("join")) || (gameName = inventoryParent.getFirstPropertyByName("join").orElseThrow().getPropertyData().node("gameName").getString()) == null || (game = Main.getInstance().getGameByName(gameName)) == null) continue;
            ret.add(game);
        }
        return ret;
    }

    public void onClick(PostClickEvent event) {
        String mode = this.inventoryMap.keySet().stream().filter(key -> event.getFormat() == this.inventoryMap.get(key)).findFirst().orElse(labels.get(1));
        PlayerItemInfo item = event.getItem();
        ItemStack stack = item.getStack();
        Player player = event.getPlayer().as(Player.class);
        List<Property> properties = item.getProperties();
        if (stack != null && item.hasProperties()) {
            Message couldNotFindGameMessage = LanguageService.getInstance().get(MessageKeys.GAMES_INVENTORY_CANNOT_FIND_GAME);
            sba.sl.pa.Player playerWrapper = Players.wrapPlayer(player);
            player.closeInventory();
            properties.stream().filter(Property::hasName).forEach(property -> {
                switch (property.getPropertyName().toLowerCase()) {
                    case "exit": {
                        break;
                    }
                    case "randomly_join": {
                        List<Game> games = this.getGamesWithMode(mode);
                        if (games == null || games.isEmpty()) {
                            couldNotFindGameMessage.send(playerWrapper);
                            return;
                        }
                        Random r = new Random();
                        games.sort(Comparator.comparing(c -> ((Game)c).getConnectedPlayers().size()).reversed().thenComparing(c -> r.nextInt()));
                        games.stream().filter(game -> game.getStatus() == GameStatus.WAITING).findAny().ifPresentOrElse(game -> game.joinToGame(player), () -> couldNotFindGameMessage.send(playerWrapper));
                        break;
                    }
                    case "rejoin": {
                        player.performCommand("bw rejoin");
                        break;
                    }
                    case "join": {
                        String gameName = item.getFirstPropertyByName("join").orElseThrow().getPropertyData().node("gameName").getString();
                        if (gameName == null) {
                            couldNotFindGameMessage.send(playerWrapper);
                            return;
                        }
                        Main.getInstance().getGameByName(gameName).joinToGame(player);
                        break;
                    }
                }
            });
        }
    }
}

