/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.service;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBASpawnerTierUpgradeEvent;
import io.github.pronze.sba.game.Arena;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.game.RotatingGenerator;
import io.github.pronze.sba.utils.Logger;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.screamingsandals.bedwars.api.events.BedwarsGameStartedEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.ItemSpawner;
import sba.sl.pu.ServiceManager;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;
import sba.sl.u.reflect.Reflect;

@Service
public class DynamicSpawnerLimiterService
implements Listener {
    private final Map<String, Map<Integer, Integer>> limiters = new HashMap<String, Map<Integer, Integer>>();

    public static DynamicSpawnerLimiterService getInstance() {
        return ServiceManager.get(DynamicSpawnerLimiterService.class);
    }

    public static final int romanToInteger2(String s) {
        LinkedHashMap<Character, Integer> values = new LinkedHashMap<Character, Integer>();
        values.put(Character.valueOf('0'), 0);
        values.put(Character.valueOf('I'), 1);
        values.put(Character.valueOf('V'), 5);
        values.put(Character.valueOf('X'), 10);
        values.put(Character.valueOf('L'), 50);
        values.put(Character.valueOf('C'), 100);
        values.put(Character.valueOf('D'), 500);
        values.put(Character.valueOf('M'), 1000);
        int number = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (i + 1 == s.length() || (Integer)values.get(Character.valueOf(s.charAt(i))) >= (Integer)values.get(Character.valueOf(s.charAt(i + 1)))) {
                number += ((Integer)values.get(Character.valueOf(s.charAt(i)))).intValue();
                continue;
            }
            number -= ((Integer)values.get(Character.valueOf(s.charAt(i)))).intValue();
        }
        return number;
    }

    @OnPostEnable
    public void onPostEnable() {
        if (SBA.isBroken()) {
            return;
        }
        SBA.getInstance().registerListener(this);
        this.load();
    }

    public void reload() {
        this.limiters.clear();
        this.load();
    }

    private void load() {
        List<String> subkeys = SBAConfig.getInstance().getSubKeys("upgrades.limit");
        for (String key : subkeys) {
            try {
                String[] parts = key.split("-");
                String item = parts[0].toLowerCase();
                int number = DynamicSpawnerLimiterService.romanToInteger2(parts.length > 1 ? parts[1] : "I");
                if (!this.limiters.containsKey(item)) {
                    this.limiters.put(item, new HashMap());
                }
                this.limiters.get(item).putIfAbsent(number, SBAConfig.getInstance().node("upgrades", "limit", key).getInt(1));
            }
            catch (Throwable t) {
                Logger.error("Key not in right format {};Expecting RESSOURCE-ROMAN_NUMERAL:TIME;{}", key, t);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGameStart(BedwarsGameStartedEvent event) {
        Game game = event.getGame();
        this.setAccordingly(game, false);
    }

    @EventHandler
    public void onSpawnerUpgrade(SBASpawnerTierUpgradeEvent event) {
        this.setAccordingly(event.getGame(), true);
    }

    public int getStartingTier(Game game, ItemSpawner spawner) {
        Map<Integer, Integer> limiter;
        String material = spawner.getItemSpawnerType().getName().toLowerCase();
        if (this.limiters.containsKey(material) && (limiter = this.limiters.get(material)).containsKey(0)) {
            return 0;
        }
        return 1;
    }

    private int getTier(Game game, ItemSpawner spawner) {
        IArena arena = ArenaManager.getInstance().get(game.getName()).orElseThrow();
        Optional<RotatingGenerator> rotating = ((Arena)arena).getRotatingGenerators().stream().map(iRotatingGenerator -> (RotatingGenerator)iRotatingGenerator).filter(generator -> generator.getItemSpawner() == spawner).findFirst();
        if (rotating.isPresent()) {
            return rotating.get().getTierLevel();
        }
        return 1;
    }

    public void setAccordingly(Game game, boolean isUpgraded) {
        for (ItemSpawner spawner : game.getItemSpawners()) {
            int tier;
            Map<Integer, Integer> limiter;
            String material;
            if (spawner.getItemSpawnerType() == null || !this.limiters.containsKey(material = spawner.getItemSpawnerType().getName().toLowerCase()) || !(limiter = this.limiters.get(material)).containsKey(tier = this.getTier(game, spawner))) continue;
            Reflect.setField((Object)spawner, "maxSpawnedResources", (Object)limiter.get(tier));
        }
    }

    public Map<String, Map<Integer, Integer>> getLimiters() {
        return this.limiters;
    }
}

