/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.utils.citizens;

import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.specials.SpawnerProtection;
import io.github.pronze.sba.utils.Logger;
import java.util.List;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.RayTraceResult;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.Game;
import sba.sl.u.reflect.ClassMethod;
import sba.sl.u.reflect.Reflect;

public class BedwarsBlockPlace
extends Trait {
    boolean useStores = SBAConfig.getInstance().ai().useStores();
    Material fallback = Material.matchMaterial((String)SBAConfig.getInstance().ai().infiniteItem());
    int cooldown = 10;
    int timerRefresh = 10;
    int blockBreakerCooldown = 0;
    int blockBreakerTotal = 0;
    Block blockToBreak = null;
    Location startBreak = null;
    double cancelBreakMovement = 0.5;
    private boolean isInNeedOfBlock = false;

    public BedwarsBlockPlace() {
        super("BedwarsBlockPlace");
    }

    public Block getAgainst(Block toPlace) {
        for (Block testBlock : List.of(toPlace.getRelative(BlockFace.DOWN), toPlace.getRelative(BlockFace.EAST), toPlace.getRelative(BlockFace.WEST), toPlace.getRelative(BlockFace.NORTH), toPlace.getRelative(BlockFace.SOUTH))) {
            if (!testBlock.getType().isSolid()) continue;
            return testBlock;
        }
        return null;
    }

    public boolean placeBlockIfPossible(Location currentLocation) {
        Block against;
        if (this.cooldown > 0) {
            return false;
        }
        Block block = currentLocation.getBlock();
        Player aiPlayer = (Player)this.npc.getEntity();
        ItemStack blockToPlace = this.getBlock((Inventory)aiPlayer.getInventory());
        if (blockToPlace != null && (against = this.getAgainst(block)) != null) {
            BlockPlaceEvent placeEvent = new BlockPlaceEvent(block, block.getState(), against, blockToPlace, aiPlayer, true);
            Bukkit.getPluginManager().callEvent((Event)placeEvent);
            if (!placeEvent.isCancelled()) {
                block.setType(blockToPlace.getType());
                if (blockToPlace.getAmount() > 1) {
                    blockToPlace.setAmount(blockToPlace.getAmount() - 1);
                } else {
                    aiPlayer.getInventory().remove(blockToPlace);
                }
                this.cooldown = 0;
                return true;
            }
        }
        return false;
    }

    public Block viewedBlock(Block b) {
        Player aiPlayer = (Player)this.getNPC().getEntity();
        if (aiPlayer == null) {
            return null;
        }
        World w = aiPlayer.getWorld();
        RayTraceResult rayTraceCheck = w.rayTraceBlocks(aiPlayer.getEyeLocation(), aiPlayer.getEyeLocation().subtract(b.getLocation()).getDirection(), 10.0);
        if (rayTraceCheck == null) {
            return null;
        }
        return rayTraceCheck.getHitBlock();
    }

    public boolean isBreakableBlock(Block b) {
        if (this.isBreaking()) {
            return false;
        }
        Player aiPlayer = (Player)this.npc.getEntity();
        Game g = Main.getInstance().getGameOfPlayer(aiPlayer);
        if (g == null) {
            return false;
        }
        if (!g.isBlockAddedDuringGame(b.getLocation())) {
            return false;
        }
        return this.isBlockVisible(b);
    }

    public boolean isBlockVisible(Block b) {
        try {
            Player aiPlayer = (Player)this.getNPC().getEntity();
            if (aiPlayer == null) {
                return false;
            }
            World w = aiPlayer.getWorld();
            RayTraceResult rayTraceCheck = w.rayTraceBlocks(aiPlayer.getEyeLocation(), aiPlayer.getEyeLocation().subtract(b.getLocation()).getDirection(), 10.0);
            if (rayTraceCheck == null) {
                return false;
            }
            return rayTraceCheck.getHitBlock().equals((Object)b);
        }
        catch (Throwable t) {
            return true;
        }
    }

    public void breakBlock(Block b) {
        if (b != null) {
            Player aiPlayer = (Player)this.npc.getEntity();
            float destroySpeed = 1.0f;
            if (Reflect.hasMethod(b.getClass(), "getDestroySpeed", ItemStack.class, Boolean.TYPE)) {
                ClassMethod method = Reflect.getMethod(b.getClass(), "getDestroySpeed", ItemStack.class, Boolean.TYPE);
                destroySpeed = ((Float)method.invokeInstance(b, aiPlayer.getItemInHand(), true)).floatValue();
            }
            this.blockBreakerCooldown = (int)(100.0f / destroySpeed);
            this.blockBreakerTotal = (int)(100.0f / destroySpeed);
            this.blockToBreak = b;
            this.startBreak = aiPlayer.getLocation();
            this.npc.getNavigator().cancelNavigation();
        }
    }

    public boolean isBreaking() {
        return this.blockToBreak != null;
    }

    public void run() {
        if (this.cooldown-- < 0) {
            this.cooldown = 0;
        }
        if (this.blockToBreak != null) {
            Player aiPlayer = (Player)this.npc.getEntity();
            if (aiPlayer.getLocation().distance(this.startBreak) > this.cancelBreakMovement) {
                this.blockToBreak = null;
                this.blockBreakerCooldown = 0;
            } else if (this.blockBreakerCooldown-- <= 0) {
                BlockBreakEvent bbe = new BlockBreakEvent(this.blockToBreak, aiPlayer);
                Bukkit.getPluginManager().callEvent((Event)bbe);
                if (!bbe.isCancelled()) {
                    this.blockToBreak.breakNaturally(aiPlayer.getItemInHand());
                }
                this.blockToBreak = null;
            } else if (this.timerRefresh++ > 10) {
                this.timerRefresh = 0;
                Game g = Main.getInstance().getGameOfPlayer(aiPlayer);
                g.getConnectedPlayers().forEach(otherPlayer -> otherPlayer.sendBlockDamage(this.blockLocation(this.blockToBreak.getLocation()), 1.0f - (float)this.blockBreakerCooldown / (float)this.blockBreakerTotal));
            }
        }
    }

    public boolean isEmpty(Block testBlock) {
        return testBlock.getType() == Material.AIR || testBlock.getType() == Material.LAVA || testBlock.getType() == Material.WATER;
    }

    public ItemStack getBlock(Inventory inv) {
        ItemStack is = null;
        if (this.useStores) {
            for (ItemStack item : inv.getContents()) {
                if (item == null || !item.getType().isBlock()) continue;
                is = item;
            }
            boolean bl = this.isInNeedOfBlock = is == null;
            if (is == null) {
                Logger.trace("NPC {} needs blocks", this.getNPC().getName());
            }
        } else {
            return new ItemStack(Material.getMaterial((String)SBAConfig.getInstance().ai().infiniteItem()));
        }
        return is;
    }

    public boolean isJumpPlacable(Location currentLocation) {
        Block b1 = currentLocation.getBlock();
        return this.isPlacable(currentLocation) && this.isEmpty(b1.getRelative(BlockFace.UP)) && this.isEmpty(b1.getRelative(BlockFace.UP).getRelative(BlockFace.UP));
    }

    public boolean isPlacable(Location currentLocation) {
        Player aiPlayer = (Player)this.npc.getEntity();
        return !SpawnerProtection.getInstance().isProtected(Main.getInstance().getGameOfPlayer(aiPlayer), currentLocation) && this.getAgainst(currentLocation.getBlock()) != null && this.isEmpty(currentLocation.getBlock());
    }

    public boolean teleport(Player aiPlayer, Location l) {
        try {
            if (this.isEmpty(l.getBlock()) && this.isEmpty(l.getBlock().getRelative(BlockFace.UP))) {
                aiPlayer.teleport(l);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public Location blockLocation(Location l) {
        return new Location(l.getWorld(), (double)l.getBlockX(), (double)l.getBlockY(), (double)l.getBlockZ());
    }

    public boolean isInNeedOfBlock() {
        return this.isInNeedOfBlock;
    }

    public void setInNeedOfBlock(boolean isInNeedOfBlock) {
        this.isInNeedOfBlock = isInNeedOfBlock;
    }
}

