/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.utils.citizens;

import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.citizens.BedwarsBlockPlace;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.trait.CurrentLocation;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class BridgePillarTrait
extends Trait {
    private boolean isTracking = false;
    private BedwarsBlockPlace blockPlace;
    private LinkedList<Location> locations = new LinkedList();
    private double treashold = 2.3;
    int timer = 0;

    public BridgePillarTrait() {
        super("BridgePillar");
    }

    public void onSpawn() {
        this.isTracking = true;
        this.npc.getTraits().forEach(t -> {
            if (t instanceof BedwarsBlockPlace) {
                this.blockPlace = (BedwarsBlockPlace)((Object)t);
            }
        });
        this.npc.getNavigator().getLocalParameters().stuckAction(new StuckAction(){

            public boolean run(NPC arg0, Navigator arg1) {
                return BridgePillarTrait.this.unstuck(arg0.getEntity().getLocation());
            }
        });
    }

    public void onDespawn() {
        this.isTracking = false;
    }

    public void onRemove() {
        this.isTracking = false;
    }

    public boolean isEmpty(Block testBlock) {
        return testBlock.getType() == Material.AIR || testBlock.getType() == Material.LAVA || testBlock.getType() == Material.WATER;
    }

    public boolean canBuildUp(Location loc) {
        Block testBlock = loc.getBlock();
        return this.isEmpty(testBlock) && this.isEmpty(testBlock.getRelative(BlockFace.DOWN)) && this.isEmpty(testBlock.getRelative(BlockFace.UP));
    }

    public boolean canMove(Location loc) {
        Block testBlock = loc.getBlock();
        return this.isEmpty(testBlock.getRelative(BlockFace.DOWN)) && this.isEmpty(testBlock.getRelative(BlockFace.UP));
    }

    private Location tryFindingJump(Location currentLocation, Location target) {
        Block b = currentLocation.getBlock();
        Block toPlace = null;
        double testDistance = Double.MAX_VALUE;
        for (Block testBlock : List.of(b.getRelative(BlockFace.EAST), b.getRelative(BlockFace.WEST), b.getRelative(BlockFace.NORTH), b.getRelative(BlockFace.SOUTH))) {
            double distanceToTarget = testBlock.getLocation().distance(target);
            if (!this.isEmpty(testBlock) || !this.isEmpty(testBlock.getRelative(BlockFace.DOWN)) || !this.isEmpty(testBlock.getRelative(BlockFace.UP)) || !(distanceToTarget < testDistance)) continue;
            testDistance = distanceToTarget;
            toPlace = testBlock;
        }
        if (toPlace != null) {
            if (this.blockPlace.placeBlockIfPossible(toPlace.getLocation())) {
                this.npc.getEntity().teleport(toPlace.getLocation().clone().add(0.0, 1.0, 0.0));
            }
            return toPlace.getLocation();
        }
        return null;
    }

    public boolean teleport(Player aiPlayer, Location l) {
        return this.blockPlace.teleport(aiPlayer, l);
    }

    public void run() {
        if (this.timer-- <= 0) {
            this.timer = 4;
            if (this.isTracking && this.npc.getNavigator().isNavigating()) {
                Location currentLocation = ((CurrentLocation)this.npc.getOrAddTrait(CurrentLocation.class)).getLocation();
                this.locations.add(currentLocation);
                if (this.locations.size() > 5) {
                    this.locations.removeFirst();
                }
                double distance = 0.0;
                if (this.locations.size() == 1) {
                    distance = Double.MAX_VALUE;
                }
                Iterator it = this.locations.iterator();
                Location current = null;
                if (it.hasNext()) {
                    current = (Location)it.next();
                    while (it.hasNext()) {
                        Location tmp = (Location)it.next();
                        distance += tmp.distance(current);
                        current = tmp;
                    }
                }
                if (distance < this.treashold && !this.blockPlace.isBreaking()) {
                    this.unstuck(currentLocation);
                }
            }
        }
    }

    public Location blockLocation(Location l) {
        return this.blockPlace.blockLocation(l);
    }

    public boolean unstuck(Location currentLocation) {
        Logger.trace("NPC IS STUCK {}", this.getNPC().getName());
        if (this.blockPlace == null) {
            this.npc.getTraits().forEach(t -> {
                if (t instanceof BedwarsBlockPlace) {
                    this.blockPlace = (BedwarsBlockPlace)((Object)t);
                }
            });
            if (this.blockPlace == null) {
                return false;
            }
        }
        Location target = this.npc.getNavigator().getTargetAsLocation();
        Location horizontal = target.clone();
        horizontal.setY(currentLocation.getY());
        if (target.getBlockY() > currentLocation.getBlockY() && this.blockPlace.isJumpPlacable(currentLocation)) {
            if (this.blockPlace.placeBlockIfPossible(currentLocation)) {
                Player aiPlayer = (Player)this.npc.getEntity();
                this.teleport(aiPlayer, this.blockLocation(currentLocation).add(0.5, 1.0, 0.5));
                return true;
            }
        } else {
            Player aiPlayer;
            double distanceToTarget;
            if (target.getBlockY() < currentLocation.getBlockY() - 2 && horizontal.distance(currentLocation) < 2.0) {
                Block standingOn = currentLocation.getBlock().getRelative(BlockFace.DOWN);
                Logger.trace("standingOn {}", standingOn);
                if (this.blockPlace.isBreakableBlock(standingOn)) {
                    Player aiPlayer2 = (Player)this.npc.getEntity();
                    this.teleport(aiPlayer2, this.blockLocation(standingOn.getLocation()).add(0.5, 1.0, 0.5));
                    this.blockPlace.breakBlock(standingOn);
                    Logger.trace("starting breaking of {}", standingOn);
                    return false;
                }
                Player aiPlayer3 = (Player)this.npc.getEntity();
                Location l = this.tryFindingJump(currentLocation, target);
                this.teleport(aiPlayer3, l);
                return true;
            }
            Block b = currentLocation.getBlock().getRelative(BlockFace.DOWN);
            Block toPlace = null;
            double testDistance = Double.MAX_VALUE;
            Location toMove = null;
            for (Block testBlock : List.of(b.getRelative(BlockFace.EAST), b.getRelative(BlockFace.WEST), b.getRelative(BlockFace.NORTH), b.getRelative(BlockFace.SOUTH))) {
                if (this.isEmpty(testBlock.getRelative(BlockFace.DOWN)) || !this.canMove(testBlock.getLocation()) || !((distanceToTarget = testBlock.getLocation().distance(target)) < testDistance) || !this.blockPlace.isPlacable(testBlock.getLocation())) continue;
                testDistance = distanceToTarget;
                toMove = testBlock.getLocation().clone().add(0.5, 0.0, 0.5);
            }
            for (Block testBlock : List.of(b.getRelative(BlockFace.EAST), b.getRelative(BlockFace.WEST), b.getRelative(BlockFace.NORTH), b.getRelative(BlockFace.SOUTH))) {
                distanceToTarget = testBlock.getLocation().distance(target);
                if (!this.canBuildUp(testBlock.getLocation()) || !(distanceToTarget < testDistance) || !this.blockPlace.isPlacable(testBlock.getLocation())) continue;
                testDistance = distanceToTarget;
                toMove = null;
                toPlace = testBlock;
            }
            if (toMove != null) {
                aiPlayer = (Player)this.npc.getEntity();
                this.teleport(aiPlayer, toMove);
                return true;
            }
            if (toPlace != null) {
                if (this.blockPlace.placeBlockIfPossible(toPlace.getLocation())) {
                    aiPlayer = (Player)this.npc.getEntity();
                    this.teleport(aiPlayer, this.blockLocation(toPlace.getLocation()).clone().add(0.5, 1.0, 0.5));
                    return true;
                }
            } else {
                b = currentLocation.getBlock();
                testDistance = Double.MAX_VALUE;
                Block toBreak = null;
                for (Block testBlock : List.of(b.getRelative(BlockFace.EAST), b.getRelative(BlockFace.WEST), b.getRelative(BlockFace.NORTH), b.getRelative(BlockFace.SOUTH), b.getRelative(BlockFace.EAST).getRelative(BlockFace.DOWN), b.getRelative(BlockFace.WEST).getRelative(BlockFace.DOWN), b.getRelative(BlockFace.NORTH).getRelative(BlockFace.DOWN), b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.DOWN), b.getRelative(BlockFace.EAST).getRelative(BlockFace.UP), b.getRelative(BlockFace.WEST).getRelative(BlockFace.UP), b.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP), b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP), b.getRelative(BlockFace.EAST).getRelative(BlockFace.UP).getRelative(BlockFace.UP), b.getRelative(BlockFace.WEST).getRelative(BlockFace.UP).getRelative(BlockFace.UP), b.getRelative(BlockFace.NORTH).getRelative(BlockFace.UP).getRelative(BlockFace.UP), b.getRelative(BlockFace.SOUTH).getRelative(BlockFace.UP).getRelative(BlockFace.UP), b.getRelative(BlockFace.UP).getRelative(BlockFace.UP))) {
                    double distanceToTarget2 = testBlock.getLocation().distance(target);
                    if (!this.blockPlace.isBreakableBlock(testBlock) || !(distanceToTarget2 < testDistance) || !this.blockPlace.isPlacable(testBlock.getLocation())) continue;
                    testDistance = distanceToTarget2;
                    toBreak = testBlock;
                    toMove = null;
                }
                if (toBreak != null) {
                    this.blockPlace.breakBlock(toBreak);
                    return false;
                }
            }
        }
        return false;
    }

    public double getTreashold() {
        return this.treashold;
    }

    public void setTreashold(double treashold) {
        this.treashold = treashold;
    }
}

