/*
 * Decompiled with CFR 0.152.
 */
package sba.c.serialize;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import sba.c.ConfigurationNode;
import sba.c.ConfigurationOptions;
import sba.c.serialize.SerializationException;
import sba.c.serialize.TypeSerializer;
import sba.c.util.CheckedConsumer;

public abstract class AbstractListChildSerializer<T>
implements TypeSerializer<T> {
    protected AbstractListChildSerializer() {
    }

    @Override
    public final T deserialize(Type type, ConfigurationNode node) throws SerializationException {
        Type entryType = this.elementType(type);
        @Nullable TypeSerializer<?> entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        if (node.isList()) {
            List<? extends ConfigurationNode> values = node.childrenList();
            T ret = this.createNew(values.size(), entryType);
            for (int i = 0; i < values.size(); ++i) {
                try {
                    this.deserializeSingle(i, ret, entrySerial.deserialize(entryType, values.get(i)));
                    continue;
                }
                catch (SerializationException ex) {
                    ex.initPath(values.get(i)::path);
                    throw ex;
                }
            }
            return ret;
        }
        @Nullable Object unwrappedVal = node.raw();
        if (unwrappedVal != null) {
            T ret = this.createNew(1, entryType);
            this.deserializeSingle(0, ret, entrySerial.deserialize(entryType, node));
            return ret;
        }
        return this.createNew(0, entryType);
    }

    @Override
    public final void serialize(Type type, @Nullable T obj, ConfigurationNode node) throws SerializationException {
        Type entryType = this.elementType(type);
        @Nullable TypeSerializer<?> entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        node.raw(Collections.emptyList());
        if (obj != null) {
            this.forEachElement(obj, el -> {
                ConfigurationNode child = node.appendListNode();
                try {
                    entrySerial.serialize(entryType, el, child);
                }
                catch (SerializationException ex) {
                    ex.initPath(child::path);
                    throw ex;
                }
            });
        }
    }

    @Override
    public @Nullable T emptyValue(Type specificType, ConfigurationOptions options) {
        try {
            return this.createNew(0, this.elementType(specificType));
        }
        catch (SerializationException ex) {
            return null;
        }
    }

    protected abstract Type elementType(Type var1) throws SerializationException;

    protected abstract T createNew(int var1, Type var2) throws SerializationException;

    protected abstract void forEachElement(T var1, CheckedConsumer<Object, SerializationException> var2) throws SerializationException;

    protected abstract void deserializeSingle(int var1, T var2, @Nullable Object var3) throws SerializationException;
}

