/*
 * Decompiled with CFR 0.152.
 */
package sba.si.builder;

import java.util.List;
import lombok.NonNull;
import sba.si.builder.BuilderUtils;
import sba.si.builder.CategoryBuilder;
import sba.si.builder.ItemInfoBuilder;
import sba.si.builder.QueueBuilder;
import sba.si.inventory.Clone;
import sba.si.inventory.GenericItemInfo;
import sba.si.inventory.HiddenCategory;
import sba.si.inventory.Include;
import sba.si.inventory.Insert;
import sba.si.inventory.InventorySet;
import sba.si.inventory.Queueable;
import sba.si.inventory.SimpleItemQueue;
import sba.si.inventory.SubInventory;
import sba.si.inventory.SubInventoryLike;
import sba.sl.u.ReceiverConsumer;

public abstract class AbstractQueueBuilder<T extends AbstractQueueBuilder<T>> {
    public T category(Object material) {
        this.item(material);
        return this.self();
    }

    public T category(Object material, ReceiverConsumer<ItemInfoBuilder> consumer) {
        this.item(material, consumer);
        return this.self();
    }

    public T item(Object material) {
        GenericItemInfo itemInfo = this.build(material);
        this.putObjectToQueue(itemInfo);
        return this.self();
    }

    public T item(Object material, ReceiverConsumer<ItemInfoBuilder> consumer) {
        GenericItemInfo itemInfo = this.build(material);
        this.putObjectToQueue(itemInfo);
        ItemInfoBuilder builder = ItemInfoBuilder.of(itemInfo);
        consumer.accept(builder);
        builder.processItemBuilderIfOpened();
        return this.self();
    }

    public T cosmetic() {
        GenericItemInfo itemInfo = new GenericItemInfo(this.getFormat());
        Clone clone = new Clone();
        clone.setCloneLink("cosmetic");
        itemInfo.setRequestedClone(clone);
        this.putObjectToQueue(itemInfo);
        return this.self();
    }

    public T cosmetic(ReceiverConsumer<ItemInfoBuilder> consumer) {
        GenericItemInfo itemInfo = new GenericItemInfo(this.getFormat());
        Clone clone = new Clone();
        clone.setCloneLink("cosmetic");
        itemInfo.setRequestedClone(clone);
        this.putObjectToQueue(itemInfo);
        ItemInfoBuilder builder = ItemInfoBuilder.of(itemInfo);
        consumer.accept(builder);
        builder.processItemBuilderIfOpened();
        return this.self();
    }

    public T itemClone(String link) {
        GenericItemInfo itemInfo = new GenericItemInfo(this.getFormat());
        Clone clone = new Clone();
        clone.setCloneLink(link);
        itemInfo.setRequestedClone(clone);
        this.putObjectToQueue(itemInfo);
        return this.self();
    }

    public T itemClone(String link, ReceiverConsumer<ItemInfoBuilder> consumer) {
        GenericItemInfo itemInfo = new GenericItemInfo(this.getFormat());
        Clone clone = new Clone();
        clone.setCloneLink(link);
        itemInfo.setRequestedClone(clone);
        this.putObjectToQueue(itemInfo);
        ItemInfoBuilder builder = ItemInfoBuilder.of(itemInfo);
        consumer.accept(builder);
        builder.processItemBuilderIfOpened();
        return this.self();
    }

    public T include(String include) {
        this.putObjectToQueue(Include.of(include));
        return this.self();
    }

    public T include(Include include) {
        this.putObjectToQueue(include);
        return this.self();
    }

    public T hidden(String id, ReceiverConsumer<CategoryBuilder> consumer) {
        HiddenCategory itemInfo = new HiddenCategory(this.getFormat(), id);
        itemInfo.setChildInventory(new SubInventory(false, itemInfo, this.getFormat()));
        this.putObjectToQueue(itemInfo);
        consumer.accept(CategoryBuilder.of(itemInfo.getChildInventory()));
        return this.self();
    }

    public T hidden(String id) {
        HiddenCategory itemInfo = new HiddenCategory(this.getFormat(), id);
        itemInfo.setChildInventory(new SubInventory(false, itemInfo, this.getFormat()));
        this.putObjectToQueue(itemInfo);
        return this.self();
    }

    public T insert(String link, ReceiverConsumer<QueueBuilder> consumer) {
        SimpleItemQueue prebuiltInventory = SimpleItemQueue.of();
        Insert insert = new Insert(link, prebuiltInventory);
        this.putObjectToQueue(insert);
        consumer.accept(QueueBuilder.of(this.getFormat(), prebuiltInventory));
        return this.self();
    }

    public T insert(String link, SubInventoryLike<?> prebuiltInventory) {
        Insert insert = new Insert(link, prebuiltInventory);
        this.putObjectToQueue(insert);
        return this.self();
    }

    public T insert(List<String> links, ReceiverConsumer<QueueBuilder> consumer) {
        SimpleItemQueue prebuiltInventory = SimpleItemQueue.of();
        consumer.accept(QueueBuilder.of(this.getFormat(), prebuiltInventory));
        return this.insert(links, prebuiltInventory);
    }

    public T insert(List<String> links, SubInventoryLike<?> prebuiltInventory) {
        links.forEach(s -> this.insert((String)s, prebuiltInventory));
        return this.self();
    }

    protected GenericItemInfo build(Object stack) {
        return BuilderUtils.buildItem(this.getFormat(), stack);
    }

    public T call(ReceiverConsumer<T> consumer) {
        consumer.accept(this.self());
        return this.self();
    }

    protected T self() {
        return (T)this;
    }

    protected abstract void putObjectToQueue(@NonNull Queueable var1);

    protected abstract InventorySet getFormat();
}

