/*
 * Decompiled with CFR 0.152.
 */
package sba.si.events;

import sba.si.builder.AnimationBuilder;
import sba.si.inventory.GenericItemInfo;
import sba.si.inventory.InventorySet;
import sba.si.inventory.PlayerItemInfo;
import sba.sl.ev.Event;
import sba.sl.i.ItemStack;
import sba.sl.i.builder.ItemStackBuilder;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.pa.Player;
import sba.sl.u.ReceiverConsumer;

public class ItemRenderEvent
implements Event {
    private final PlayerItemInfo item;

    public InventorySet getFormat() {
        return this.item.getFormat();
    }

    public PlayerItemInfo getInfo() {
        return this.item;
    }

    public GenericItemInfo getOriginalInfo() {
        return this.item.getOriginal();
    }

    public ItemStack getStack() {
        return this.item.getStack();
    }

    public void setStack(ItemStack stack) {
        this.item.setStack(stack);
    }

    public boolean isVisible() {
        return this.item.isVisible();
    }

    public void setVisible(boolean visible) {
        this.item.setVisible(visible);
    }

    public boolean isDisabled() {
        return this.item.isDisabled();
    }

    public void setDisabled(boolean disabled) {
        this.item.setDisabled(disabled);
    }

    public ItemRenderEvent disabled(boolean disabled) {
        this.setDisabled(disabled);
        return this;
    }

    public ItemRenderEvent visible(boolean visible) {
        this.setVisible(visible);
        return this;
    }

    public AnimationBuilder getAnimation() {
        return AnimationBuilder.of(this.item.getAnimation());
    }

    public ItemRenderEvent animation(ReceiverConsumer<AnimationBuilder> consumer) {
        consumer.accept(this.getAnimation());
        return this;
    }

    public ItemRenderEvent stack(ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStackBuilder builder = this.item.getStack().builder();
        consumer.accept(builder);
        ItemStack builtStack = builder.build();
        this.item.setStack(builtStack != null ? builtStack : ItemStackFactory.getAir());
        return this;
    }

    public ItemRenderEvent clearStack(ReceiverConsumer<ItemStackBuilder> consumer) {
        ItemStackBuilder builder = ItemStackFactory.builder();
        consumer.accept(builder);
        ItemStack builtStack = builder.build();
        this.item.setStack(builtStack != null ? builtStack : ItemStackFactory.getAir());
        return this;
    }

    public String process(String raw) {
        return this.item.getFormat().processPlaceholders(this.item.getPlayer(), raw, this.item);
    }

    public Player getPlayer() {
        return this.item.getPlayer();
    }

    public ItemRenderEvent player(ReceiverConsumer<Player> consumer) {
        consumer.accept(this.getPlayer());
        return this;
    }

    public PlayerItemInfo getItem() {
        return this.item;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemRenderEvent)) {
            return false;
        }
        ItemRenderEvent other = (ItemRenderEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PlayerItemInfo this$item = this.getItem();
        PlayerItemInfo other$item = other.getItem();
        return !(this$item == null ? other$item != null : !((Object)this$item).equals(other$item));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemRenderEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PlayerItemInfo $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
        return result;
    }

    public String toString() {
        return "ItemRenderEvent(item=" + this.getItem() + ")";
    }

    public ItemRenderEvent(PlayerItemInfo item) {
        this.item = item;
    }
}

