/*
 * Decompiled with CFR 0.152.
 */
package sba.si.inventory;

import sba.si.inventory.GenericItemInfo;
import sba.si.inventory.SubInventory;
import sba.si.utils.CloneMethod;
import sba.sl.spectator.Book;

public class Clone
implements Cloneable {
    private CloneMethod cloneMethod = CloneMethod.MISSING;
    private String cloneLink;

    public Clone clone() {
        Clone clone = new Clone();
        clone.cloneMethod = this.cloneMethod;
        clone.cloneLink = this.cloneLink;
        return clone;
    }

    public void cloneInto(GenericItemInfo original, GenericItemInfo newOne) {
        if (original != null) {
            if (original.getItem() != null && !original.getItem().getType().isAir() && (this.cloneMethod.isOverride() || newOne.getItem() == null || newOne.getItem().getType().isAir())) {
                newOne.setItem(original.getItem());
            }
            if (original.hasAnimation()) {
                if (!newOne.hasAnimation() || this.cloneMethod.isIncrement()) {
                    newOne.getAnimation().addAll(original.getAnimation());
                } else if (this.cloneMethod.isOverride()) {
                    newOne.getAnimation().clear();
                    newOne.getAnimation().addAll(original.getAnimation());
                }
            }
            if (original.getVisible() != null && (this.cloneMethod.isOverride() || newOne.getVisible() == null)) {
                newOne.setVisible(original.getVisible());
            }
            if (original.getDisabled() != null && (this.cloneMethod.isOverride() || newOne.getDisabled() == null)) {
                newOne.setDisabled(original.getDisabled());
            }
            newOne.getProperties().addAll(original.getProperties());
            if (original.hasBook() && (this.cloneMethod.isOverride() || !newOne.hasBook())) {
                newOne.setBook(Book.builder().title(original.getBook().title()).author(original.getBook().author()).pages(original.getBook().pages()).build());
            }
            if (original.getWritten() != null && (this.cloneMethod.isOverride() || newOne.getWritten() == null)) {
                newOne.setWritten(original.getWritten());
            }
            newOne.getEventManager().cloneEventManager(original.getEventManager());
            if (original.hasChildInventory()) {
                if (!newOne.hasChildInventory()) {
                    newOne.setChildInventory(new SubInventory(false, newOne, newOne.getFormat()));
                    original.getChildInventory().getContents().stream().map(GenericItemInfo::clone).forEach(newOne.getChildInventory().getWaitingQueue()::add);
                } else if (this.cloneMethod.isIncrement()) {
                    original.getChildInventory().getContents().stream().map(GenericItemInfo::clone).forEach(newOne.getChildInventory().getWaitingQueue()::add);
                } else if (this.cloneMethod.isOverride()) {
                    newOne.setChildInventory(new SubInventory(false, newOne, newOne.getFormat()));
                    original.getChildInventory().getContents().stream().map(GenericItemInfo::clone).forEach(newOne.getChildInventory().getWaitingQueue()::add);
                }
            }
            if (original.getLocate() != null && (newOne.getLocate() == null || this.cloneMethod.isOverride())) {
                newOne.setLocate(original.getLocate());
            }
            if (!original.getExecutions().isEmpty()) {
                if (this.cloneMethod.isIncrement() || newOne.getExecutions().isEmpty()) {
                    newOne.getExecutions().addAll(original.getExecutions());
                } else if (this.cloneMethod.isOverride()) {
                    newOne.getExecutions().clear();
                    newOne.getExecutions().addAll(original.getExecutions());
                }
            }
        }
    }

    public CloneMethod getCloneMethod() {
        return this.cloneMethod;
    }

    public String getCloneLink() {
        return this.cloneLink;
    }

    public void setCloneMethod(CloneMethod cloneMethod) {
        this.cloneMethod = cloneMethod;
    }

    public void setCloneLink(String cloneLink) {
        this.cloneLink = cloneLink;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Clone)) {
            return false;
        }
        Clone other = (Clone)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CloneMethod this$cloneMethod = this.getCloneMethod();
        CloneMethod other$cloneMethod = other.getCloneMethod();
        if (this$cloneMethod == null ? other$cloneMethod != null : !((Object)((Object)this$cloneMethod)).equals((Object)other$cloneMethod)) {
            return false;
        }
        String this$cloneLink = this.getCloneLink();
        String other$cloneLink = other.getCloneLink();
        return !(this$cloneLink == null ? other$cloneLink != null : !this$cloneLink.equals(other$cloneLink));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Clone;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CloneMethod $cloneMethod = this.getCloneMethod();
        result = result * 59 + ($cloneMethod == null ? 43 : ((Object)((Object)$cloneMethod)).hashCode());
        String $cloneLink = this.getCloneLink();
        result = result * 59 + ($cloneLink == null ? 43 : $cloneLink.hashCode());
        return result;
    }

    public String toString() {
        return "Clone(cloneMethod=" + this.getCloneMethod() + ", cloneLink=" + this.getCloneLink() + ")";
    }
}

