/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.a;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.attribute.AttributeTypeRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface AttributeType
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @NotNull
    public static AttributeType of(@MinecraftType(value=MinecraftType.Type.ATTRIBUTE_TYPE) @NotNull Object attributeType) {
        AttributeType result = AttributeType.ofNullable(attributeType);
        Preconditions.checkNotNullIllegal(result, "Could not find attribute type: " + String.valueOf(attributeType));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static AttributeType ofNullable(@MinecraftType(value=MinecraftType.Type.ATTRIBUTE_TYPE) @Nullable Object attributeType) {
        if (attributeType instanceof AttributeType) {
            return (AttributeType)attributeType;
        }
        return (AttributeType)AttributeTypeRegistry.getInstance().resolveMapping(attributeType);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull AttributeType> all() {
        return AttributeTypeRegistry.getInstance().getRegistryItemStream();
    }

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.ATTRIBUTE_TYPE) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);
}

