/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.api.types.server;

import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

@ApiStatus.NonExtendable
public interface BlockPlacementHolder
extends Wrapper {
    @NotNull
    public static BlockPlacementHolder of(@NotNull Object blockPlacement) {
        BlockPlacementHolder result = BlockPlacementHolder.ofNullable(blockPlacement);
        if (result == null) {
            throw new IllegalArgumentException("Could not wrap placed block: " + String.valueOf(blockPlacement));
        }
        return result;
    }

    @Nullable
    public static BlockPlacementHolder ofNullable(@Nullable Object blockPlacement) {
        if (Provider.provider == null) {
            throw new UnsupportedOperationException("A provider for " + BlockPlacementHolder.class.getSimpleName() + " has not been registered yet!");
        }
        if (blockPlacement == null) {
            return null;
        }
        return Provider.provider.apply(blockPlacement);
    }

    @ApiStatus.Internal
    public static final class Provider {
        @Nullable
        private static @Nullable Function<@NotNull Object, @Nullable BlockPlacementHolder> provider;

        private Provider() {
        }

        public static void registerProvider(@NotNull @NotNull Function<@NotNull Object, @Nullable BlockPlacementHolder> provider) {
            if (Provider.provider != null) {
                throw new UnsupportedOperationException("A provider for " + BlockPlacementHolder.class.getSimpleName() + " has already been registered!");
            }
            Provider.provider = provider;
        }
    }
}

