/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.co;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.c.serialize.TypeSerializer;
import sba.sl.Server;
import sba.sl.a.AttributeModifier;
import sba.sl.a.AttributeType;
import sba.sl.a.ItemAttribute;
import sba.sl.co.AttributeModifierSerializer;
import sba.sl.sl.EquipmentSlotGroup;
import sba.sl.u.ResourceLocation;

public class ItemAttributeSerializer
implements TypeSerializer<ItemAttribute> {
    @NotNull
    private static final String TYPE_KEY = "type";
    @NotNull
    private static final String ID_KEY = "id";
    @NotNull
    private static final String UUID_KEY = "uuid";
    @NotNull
    private static final String NAME_KEY = "name";
    @NotNull
    private static final String AMOUNT_KEY = "amount";
    @NotNull
    private static final String OPERATION_KEY = "operation";
    @NotNull
    private static final String SLOT_KEY = "slot";
    @NotNull
    public static final ItemAttributeSerializer INSTANCE = new ItemAttributeSerializer();

    @Override
    @NotNull
    public ItemAttribute deserialize(@NotNull Type type, @NotNull ConfigurationNode node) throws SerializationException {
        try {
            ConfigurationNode attributeType = node.node(TYPE_KEY);
            ConfigurationNode id = node.node(ID_KEY);
            ConfigurationNode uuid = node.node(UUID_KEY);
            ConfigurationNode name = node.node(NAME_KEY);
            ConfigurationNode amount = node.node(AMOUNT_KEY);
            ConfigurationNode operation = node.node(OPERATION_KEY);
            ConfigurationNode slot = node.node(SLOT_KEY);
            AttributeType typeOpt = AttributeType.of(Objects.requireNonNull(attributeType.raw()));
            if (!id.empty()) {
                return new ItemAttribute(typeOpt, ResourceLocation.of(id.getString("")), amount.getDouble(), AttributeModifierSerializer.read(operation.getString(""), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.of(slot.getString("any")));
            }
            return new ItemAttribute(typeOpt, uuid.get(UUID.class, UUID::randomUUID), name.getString(""), amount.getDouble(), AttributeModifierSerializer.read(operation.getString(""), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.of(slot.getString("any")));
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable ItemAttribute obj, @NotNull ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        node.node(TYPE_KEY).set(obj.getType().location().asString());
        if (Server.isVersion(1, 21)) {
            node.node(ID_KEY).set(obj.getLocation().toString());
        } else {
            node.node(UUID_KEY).set(obj.getUuid());
            node.node(NAME_KEY).set(obj.getName());
        }
        node.node(AMOUNT_KEY).set(obj.getAmount());
        node.node(OPERATION_KEY).set((Object)obj.getOperation());
        EquipmentSlotGroup slot = obj.getSlot();
        node.node(SLOT_KEY).set(slot.location().asString());
    }
}

