/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.co;

import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.c.serialize.TypeSerializer;
import sba.sl.i.meta.PotionEffect;

public class PotionEffectSerializer
implements TypeSerializer<PotionEffect> {
    @NotNull
    private static final String EFFECT_KEY = "effect";
    @NotNull
    private static final String DURATION_KEY = "duration";
    @NotNull
    private static final String AMPLIFIER_KEY = "amplifier";
    @NotNull
    private static final String AMBIENT_KEY = "ambient";
    @NotNull
    private static final String PARTICLES_KEY = "particles";
    @NotNull
    private static final String ICON_KEY = "icon";
    @NotNull
    public static final PotionEffectSerializer INSTANCE = new PotionEffectSerializer();

    @Override
    @NotNull
    public PotionEffect deserialize(@NotNull Type type, @NotNull ConfigurationNode node) throws SerializationException {
        try {
            if (!node.isMap()) {
                return PotionEffect.of(node.getString());
            }
            ConfigurationNode effectNode = node.node(EFFECT_KEY);
            ConfigurationNode durationNode = node.node(DURATION_KEY);
            ConfigurationNode amplifierNode = node.node(AMPLIFIER_KEY);
            ConfigurationNode ambientNode = node.node(AMBIENT_KEY);
            ConfigurationNode particlesNode = node.node(PARTICLES_KEY);
            ConfigurationNode iconNode = node.node(ICON_KEY);
            PotionEffect holder = PotionEffect.of(effectNode.getString());
            return holder.withDuration(durationNode.getInt(holder.duration())).withAmplifier(amplifierNode.getInt(holder.amplifier())).withAmbient(ambientNode.getBoolean(holder.ambient())).withParticles(particlesNode.getBoolean(node.node("has-particles").getBoolean(holder.particles()))).withIcon(iconNode.getBoolean(node.node("has-icon").getBoolean(holder.icon())));
        }
        catch (Throwable t) {
            throw new SerializationException(t);
        }
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable PotionEffect obj, @NotNull ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
            return;
        }
        node.node(EFFECT_KEY).set(obj.type().location().asString());
        node.node(DURATION_KEY).set(obj.duration());
        node.node(AMPLIFIER_KEY).set(obj.amplifier());
        node.node(AMBIENT_KEY).set(obj.ambient());
        node.node(PARTICLES_KEY).set(obj.particles());
        node.node(ICON_KEY).set(obj.icon());
    }
}

