/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.ev;

import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;
import sba.sl.ev.Cancellable;
import sba.sl.ev.Event;
import sba.sl.ev.EventExecutionOrder;
import sba.sl.u.ReceiverConsumer;

public final class EventHandler<E extends Event> {
    private @UnknownNullability(value="At the end of execution of all of methods, this attribute is not null. However, immediately after the construction, it can be null.") ReceiverConsumer<@NotNull E> consumer;
    @NotNull
    private final EventExecutionOrder executionOrder;
    private final boolean ignoreCancelled;

    @NotNull
    public static <E extends Event> EventHandler<E> of(@NotNull @NotNull ReceiverConsumer<@NotNull E> consumer) {
        return EventHandler.of(consumer, EventExecutionOrder.NORMAL, false);
    }

    @NotNull
    public static <E extends Event> EventHandler<E> of(@NotNull @NotNull ReceiverConsumer<@NotNull E> consumer, @NotNull EventExecutionOrder executionOrder) {
        return EventHandler.of(consumer, executionOrder, false);
    }

    @NotNull
    public static <E extends Event> EventHandler<E> of(@NotNull @NotNull ReceiverConsumer<@NotNull E> consumer, boolean ignoreCancelled) {
        return EventHandler.of(consumer, EventExecutionOrder.NORMAL, ignoreCancelled);
    }

    public static <E extends Event> EventHandler<E> ofOneTime(Function<@NotNull EventHandler<E>, @NotNull ReceiverConsumer<@NotNull E>> function) {
        EventHandler<E> manager = EventHandler.of(EventExecutionOrder.NORMAL, false);
        manager.consumer = function.apply(manager);
        return manager;
    }

    public static <E extends Event> EventHandler<E> ofOneTime(Function<@NotNull EventHandler<E>, @NotNull ReceiverConsumer<@NotNull E>> function, @NotNull EventExecutionOrder executionOrder) {
        EventHandler<E> manager = EventHandler.of(executionOrder, false);
        manager.consumer = function.apply(manager);
        return manager;
    }

    public static <E extends Event> EventHandler<E> ofOneTime(Function<@NotNull EventHandler<E>, @NotNull ReceiverConsumer<@NotNull E>> function, boolean ignoreCancelled) {
        EventHandler<E> manager = EventHandler.of(EventExecutionOrder.NORMAL, ignoreCancelled);
        manager.consumer = function.apply(manager);
        return manager;
    }

    public static <E extends Event> EventHandler<E> ofOneTime(Function<@NotNull EventHandler<E>, @NotNull ReceiverConsumer<@NotNull E>> function, @NotNull EventExecutionOrder executionOrder, boolean ignoreCancelled) {
        EventHandler<E> manager = EventHandler.of(executionOrder, ignoreCancelled);
        manager.consumer = function.apply(manager);
        return manager;
    }

    public void fire(@NotNull Event event) {
        try {
            if (this.ignoreCancelled && event instanceof Cancellable && ((Cancellable)((Object)event)).cancelled()) {
                return;
            }
            this.consumer.accept(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Generated
    public @UnknownNullability(value="At the end of execution of all of methods, this attribute is not null. However, immediately after the construction, it can be null.") ReceiverConsumer<@NotNull E> getConsumer() {
        return this.consumer;
    }

    @NotNull
    @Generated
    public EventExecutionOrder getExecutionOrder() {
        return this.executionOrder;
    }

    @Generated
    public boolean isIgnoreCancelled() {
        return this.ignoreCancelled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventHandler)) {
            return false;
        }
        EventHandler other = (EventHandler)o;
        if (this.isIgnoreCancelled() != other.isIgnoreCancelled()) {
            return false;
        }
        ReceiverConsumer<E> this$consumer = this.getConsumer();
        ReceiverConsumer<E> other$consumer = other.getConsumer();
        if (this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer)) {
            return false;
        }
        EventExecutionOrder this$executionOrder = this.getExecutionOrder();
        EventExecutionOrder other$executionOrder = other.getExecutionOrder();
        return !(this$executionOrder == null ? other$executionOrder != null : !((Object)((Object)this$executionOrder)).equals((Object)other$executionOrder));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIgnoreCancelled() ? 79 : 97);
        ReceiverConsumer<E> $consumer = this.getConsumer();
        result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
        EventExecutionOrder $executionOrder = this.getExecutionOrder();
        result = result * 59 + ($executionOrder == null ? 43 : ((Object)((Object)$executionOrder)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EventHandler(consumer=" + String.valueOf(this.getConsumer()) + ", executionOrder=" + String.valueOf((Object)this.getExecutionOrder()) + ", ignoreCancelled=" + this.isIgnoreCancelled() + ")";
    }

    @Generated
    private EventHandler(@NotNull EventExecutionOrder executionOrder, boolean ignoreCancelled) {
        if (executionOrder == null) {
            throw new NullPointerException("executionOrder is marked non-null but is null");
        }
        this.executionOrder = executionOrder;
        this.ignoreCancelled = ignoreCancelled;
    }

    @Generated
    private static <E extends Event> EventHandler<E> of(@NotNull EventExecutionOrder executionOrder, boolean ignoreCancelled) {
        return new EventHandler<E>(executionOrder, ignoreCancelled);
    }

    @Generated
    private EventHandler(@UnknownNullability(value="At the end of execution of all of methods, this attribute is not null. However, immediately after the construction, it can be null.") ReceiverConsumer<@NotNull E> consumer, @NotNull EventExecutionOrder executionOrder, boolean ignoreCancelled) {
        if (executionOrder == null) {
            throw new NullPointerException("executionOrder is marked non-null but is null");
        }
        this.consumer = consumer;
        this.executionOrder = executionOrder;
        this.ignoreCancelled = ignoreCancelled;
    }

    @Generated
    public static <E extends Event> EventHandler<E> of(@UnknownNullability(value="At the end of execution of all of methods, this attribute is not null. However, immediately after the construction, it can be null.") ReceiverConsumer<@NotNull E> consumer, @NotNull EventExecutionOrder executionOrder, boolean ignoreCancelled) {
        return new EventHandler<E>(consumer, executionOrder, ignoreCancelled);
    }
}

