/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.ev;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.ev.Event;
import sba.sl.ev.EventExecutionOrder;
import sba.sl.ev.EventHandler;
import sba.sl.ev.HandlerRegisteredEvent;
import sba.sl.ev.HandlerUnregisteredEvent;
import sba.sl.impl.utils.executor.ExecutorProvider;
import sba.sl.u.Controllable;
import sba.sl.u.ReceiverConsumer;
import sba.sl.u.annotations.ProvidedService;

@ProvidedService
public abstract class EventManager {
    @Nullable
    private static ExecutorService executor;
    @Nullable
    private static EventManager defaultEventManager;
    @NotNull
    private final @NotNull Map<@NotNull Class<?>, List<@NotNull EventHandler<? extends Event>>> handlers = new ConcurrentHashMap();
    @Nullable
    private EventManager customManager;

    public EventManager(Controllable controllable) {
        controllable.enable(() -> {
            executor = ExecutorProvider.buildExecutor("SEventManager");
        }).preDisable(this::destroy);
    }

    @ApiStatus.Internal
    public static void init(@NotNull @NotNull Supplier<@NotNull EventManager> supplier) {
        if (defaultEventManager != null) {
            throw new UnsupportedOperationException("Default EventManager has been already initialized!");
        }
        defaultEventManager = supplier.get();
    }

    @NotNull
    public static <K extends Event> K fire(@NotNull K event) {
        if (defaultEventManager == null) {
            throw new UnsupportedOperationException("Default EventManager has not been initialized yet!");
        }
        return defaultEventManager.fireEvent(event);
    }

    @NotNull
    public static <K extends Event> @NotNull CompletableFuture<@NotNull K> fireAsync(@NotNull K event) {
        if (defaultEventManager == null) {
            throw new UnsupportedOperationException("Default EventManager has not been initialized yet!");
        }
        return defaultEventManager.fireEventAsync(event);
    }

    @NotNull
    public static EventManager createChildManager() {
        if (defaultEventManager == null) {
            throw new UnsupportedOperationException("Default EventManager has not been initialized yet!");
        }
        return new EventManager(){

            @Override
            public boolean isServerThread() {
                return defaultEventManager.isServerThread();
            }
        };
    }

    public static boolean isDefaultInitialized() {
        return defaultEventManager != null;
    }

    @NotNull
    public <T extends Event> EventHandler<T> register(@NotNull Class<T> event, @NotNull @NotNull ReceiverConsumer<@NotNull T> consumer) {
        return this.register(event, EventHandler.of(consumer));
    }

    @NotNull
    public <T extends Event> EventHandler<T> registerOneTime(@NotNull Class<T> event, @NotNull @NotNull Function<@NotNull T, @NotNull Boolean> function) {
        return this.register(event, EventHandler.ofOneTime(handler -> e -> {
            if (((Boolean)function.apply(e)).booleanValue()) {
                this.unregister((EventHandler)handler);
            }
        }));
    }

    @NotNull
    public <T extends Event> EventHandler<T> register(@NotNull Class<T> event, @NotNull @NotNull ReceiverConsumer<@NotNull T> consumer, boolean ignoreCancelled) {
        return this.register(event, EventHandler.of(consumer, ignoreCancelled));
    }

    @NotNull
    public <T extends Event> EventHandler<T> registerOneTime(@NotNull Class<T> event, @NotNull @NotNull Function<@NotNull T, @NotNull Boolean> function, boolean ignoreCancelled) {
        return this.register(event, EventHandler.ofOneTime(handler -> e -> {
            if (((Boolean)function.apply(e)).booleanValue()) {
                this.unregister((EventHandler)handler);
            }
        }, ignoreCancelled));
    }

    @NotNull
    public <T extends Event> EventHandler<T> register(@NotNull Class<T> event, @NotNull @NotNull ReceiverConsumer<@NotNull T> consumer, @NotNull EventExecutionOrder eventPriority) {
        return this.register(event, EventHandler.of(consumer, eventPriority));
    }

    @NotNull
    public <T extends Event> EventHandler<T> registerOneTime(@NotNull Class<T> event, @NotNull @NotNull Function<@NotNull T, @NotNull Boolean> function, @NotNull EventExecutionOrder eventPriority, boolean ignoreCancelled) {
        return this.register(event, EventHandler.ofOneTime(handler -> e -> {
            if (((Boolean)function.apply(e)).booleanValue()) {
                this.unregister((EventHandler)handler);
            }
        }, eventPriority, ignoreCancelled));
    }

    @NotNull
    public <T extends Event> EventHandler<T> register(@NotNull Class<T> event, @NotNull @NotNull ReceiverConsumer<@NotNull T> consumer, @NotNull EventExecutionOrder eventPriority, boolean ignoreCancelled) {
        return this.register(event, EventHandler.of(consumer, eventPriority, ignoreCancelled));
    }

    @NotNull
    public <T extends Event> EventHandler<T> register(@NotNull Class<T> event, @NotNull EventHandler<T> handler) {
        this.handlers.computeIfAbsent(event, e -> Collections.synchronizedList(new ArrayList())).add(handler);
        this.fireEvent(new HandlerRegisteredEvent(this, event, handler));
        return handler;
    }

    public <T extends Event> void unregister(@NotNull EventHandler<T> handler) {
        this.handlers.forEach((key, value) -> {
            if (value.contains(handler)) {
                this.fireEvent(new HandlerUnregisteredEvent(this, (Class<?>)key, handler));
                value.remove(handler);
                if (value.isEmpty()) {
                    this.handlers.remove(key, value);
                }
            }
        });
    }

    @NotNull
    public <K extends Event> K fireEvent(@NotNull K event) {
        EventExecutionOrder.VALUES.forEach(order -> this.fireEvent(event, (EventExecutionOrder)((Object)order)));
        return event;
    }

    @NotNull
    public <K extends Event> K fireEvent(@NotNull K event, @NotNull EventExecutionOrder executionOrder) {
        if (event.isAsync() && this.isServerThread() && executor != null) {
            throw new UnsupportedOperationException("Async event cannot be fired sync!");
        }
        this.findEventHandlers(event, executionOrder).forEach(eventHandler -> eventHandler.fire(event));
        if (this.customManager != null) {
            this.customManager.fireEvent(event, executionOrder);
        } else if (this != defaultEventManager && defaultEventManager != null) {
            defaultEventManager.fireEvent(event, executionOrder);
        }
        return event;
    }

    @NotNull
    public <K extends Event> @NotNull CompletableFuture<@NotNull K> fireEventAsync(@NotNull K event) {
        LinkedList futures = new LinkedList();
        EventExecutionOrder.VALUES.forEach(priority -> futures.add(this.fireEventAsync(event, (EventExecutionOrder)((Object)priority))));
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignored -> event);
    }

    @NotNull
    public <K extends Event> @NotNull CompletableFuture<@NotNull K> fireEventAsync(@NotNull K event, @NotNull EventExecutionOrder executionOrder) {
        if (!event.isAsync() || executor == null) {
            return CompletableFuture.completedFuture(this.fireEvent(event, executionOrder));
        }
        LinkedList futures = this.findEventHandlers(event, executionOrder).map(eventHandler -> {
            if (this.isServerThread()) {
                return CompletableFuture.runAsync(() -> eventHandler.fire(event), executor).exceptionally(ex -> {
                    throw new RuntimeException("Exception occurred while firing event!", (Throwable)ex);
                });
            }
            return CompletableFuture.completedFuture(this.fireEvent(event, executionOrder));
        }).collect(Collectors.toCollection(LinkedList::new));
        if (this.customManager != null) {
            futures.add(this.customManager.fireEventAsync(event, executionOrder).thenApply(ignored -> null));
        } else if (this != defaultEventManager && defaultEventManager != null) {
            futures.add(defaultEventManager.fireEventAsync(event, executionOrder).thenApply(ignored -> null));
        }
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(event);
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(ignored -> event);
    }

    public void unregisterAll() {
        this.handlers.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).forEach(this::unregister);
    }

    public void drop() {
        this.handlers.clear();
    }

    public void setCustomManager(@Nullable EventManager parent) {
        if (this != defaultEventManager) {
            this.customManager = parent;
        }
    }

    public boolean isRegistered(@NotNull EventHandler<?> eventHandler) {
        return this.handlers.entrySet().stream().anyMatch(entry -> ((List)entry.getValue()).contains(eventHandler));
    }

    public void cloneEventManager(@NotNull EventManager originalEventManager) {
        originalEventManager.handlers.forEach((key, value) -> value.forEach(entry1 -> this.register((Class)key, (EventHandler)entry1)));
    }

    public void destroy() {
        this.handlers.clear();
        if (this == defaultEventManager && executor != null) {
            ExecutorProvider.destroyExecutor(executor);
        }
    }

    @NotNull
    private <E extends Event> @NotNull Stream<? extends @NotNull EventHandler<? extends Event>> findEventHandlers(@NotNull E event, @NotNull EventExecutionOrder executionOrder) {
        return this.handlers.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isInstance(event)).map(Map.Entry::getValue).flatMap(Collection::stream).filter(eventHandler -> eventHandler.getExecutionOrder() == executionOrder);
    }

    public abstract boolean isServerThread();

    @Generated
    public EventManager() {
    }

    @Nullable
    @Generated
    public static EventManager getDefaultEventManager() {
        return defaultEventManager;
    }

    @Nullable
    @Generated
    public EventManager getCustomManager() {
        return this.customManager;
    }
}

