/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.f;

import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.f.FireworkEffectType;
import sba.sl.impl.firework.FireworkEffectRegistry;
import sba.sl.spectator.Color;
import sba.sl.u.ComparableWrapper;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;

public interface FireworkEffect
extends ComparableWrapper,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @NotNull
    public FireworkEffectType type();

    @NotNull
    public @NotNull List<@NotNull Color> colors();

    @NotNull
    public @NotNull List<@NotNull Color> fadeColors();

    public boolean flicker();

    public boolean trail();

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public FireworkEffect withType(@NotNull FireworkEffectType var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public FireworkEffect withColors(@NotNull @NotNull List<@NotNull Color> var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public FireworkEffect withFadeColors(@NotNull @NotNull List<@NotNull Color> var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public FireworkEffect withFlicker(boolean var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public FireworkEffect withTrail(boolean var1);

    @Override
    public boolean is(Object ... var1);

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.FIREWORK_EFFECT) @Nullable Object var1);

    @NotNull
    public static FireworkEffect of(@MinecraftType(value=MinecraftType.Type.FIREWORK_EFFECT_OR_FIREWORK_EFFECT_TYPE) @NotNull Object effect) {
        FireworkEffect result = FireworkEffect.ofNullable(effect);
        Preconditions.checkNotNullIllegal(result, "Could not find firework effect: " + String.valueOf(effect));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static FireworkEffect ofNullable(@MinecraftType(value=MinecraftType.Type.FIREWORK_EFFECT_OR_FIREWORK_EFFECT_TYPE) @Nullable Object effect) {
        if (effect instanceof FireworkEffect) {
            return (FireworkEffect)effect;
        }
        return FireworkEffectRegistry.resolve(effect);
    }
}

