/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.f;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.firework.FireworkEffectTypeRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface FireworkEffectType
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(Object ... var1);

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.FIREWORK_EFFECT_TYPE) @Nullable Object var1);

    @NotNull
    public static FireworkEffectType of(@MinecraftType(value=MinecraftType.Type.FIREWORK_EFFECT_TYPE) @NotNull Object effectType) {
        FireworkEffectType result = FireworkEffectType.ofNullable(effectType);
        Preconditions.checkNotNullIllegal(result, "Could not find firework effect type: " + String.valueOf(effectType));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static FireworkEffectType ofNullable(@MinecraftType(value=MinecraftType.Type.FIREWORK_EFFECT_TYPE) @Nullable Object effectType) {
        if (effectType instanceof FireworkEffectType) {
            return (FireworkEffectType)effectType;
        }
        return (FireworkEffectType)FireworkEffectTypeRegistry.getInstance().resolveMapping(effectType);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull FireworkEffectType> all() {
        return FireworkEffectTypeRegistry.getInstance().getRegistryItemStream();
    }
}

