/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.i.meta;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.item.meta.PotionRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface Potion
extends RegistryItem {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.POTION) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static Potion of(@MinecraftType(value=MinecraftType.Type.POTION) @NotNull Object potion) {
        Potion result = Potion.ofNullable(potion);
        Preconditions.checkNotNullIllegal(result, "Could not find potion: " + String.valueOf(potion));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static Potion ofNullable(@MinecraftType(value=MinecraftType.Type.POTION) @Nullable Object potion) {
        if (potion instanceof Potion) {
            return (Potion)potion;
        }
        return (Potion)PotionRegistry.getInstance().resolveMapping(potion);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull Potion> all() {
        return PotionRegistry.getInstance().getRegistryItemStream();
    }
}

