/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.adventure.spectator.sound;

import java.util.OptionalLong;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.k.a.key.Key;
import sba.k.a.sound.Sound;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.adventure.spectator.AdventureFeature;
import sba.sl.impl.adventure.spectator.sound.AdventureSoundSource;
import sba.sl.spectator.sound.SoundSource;
import sba.sl.spectator.sound.SoundStart;
import sba.sl.u.BasicWrapper;
import sba.sl.u.Preconditions;
import sba.sl.u.ResourceLocation;

public class AdventureSoundStart
extends BasicWrapper<Sound>
implements SoundStart {
    public AdventureSoundStart(@NotNull Sound wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public ResourceLocation soundKey() {
        return ResourceLocation.of(((Sound)this.wrappedObject).name().namespace(), ((Sound)this.wrappedObject).name().value());
    }

    @Override
    @NotNull
    public SoundStart withSoundKey(@NotNull ResourceLocation soundKey) {
        return new AdventureSoundStart(Sound.sound(Key.key(soundKey.namespace(), soundKey.path()), ((Sound)this.wrappedObject).source(), ((Sound)this.wrappedObject).volume(), ((Sound)this.wrappedObject).pitch()));
    }

    @Override
    @NotNull
    public SoundSource source() {
        return new AdventureSoundSource(((Sound)this.wrappedObject).source());
    }

    @Override
    @NotNull
    public SoundStart withSource(@NotNull SoundSource source) {
        return new AdventureSoundStart(Sound.sound(((Sound)this.wrappedObject).name(), source.as(Sound.Source.class), ((Sound)this.wrappedObject).volume(), ((Sound)this.wrappedObject).pitch()));
    }

    @Override
    public float volume() {
        return ((Sound)this.wrappedObject).volume();
    }

    @Override
    @NotNull
    public SoundStart withVolume(float volume) {
        return new AdventureSoundStart(Sound.sound(((Sound)this.wrappedObject).name(), ((Sound)this.wrappedObject).source(), volume, ((Sound)this.wrappedObject).pitch()));
    }

    @Override
    public float pitch() {
        return ((Sound)this.wrappedObject).pitch();
    }

    @Override
    @NotNull
    public SoundStart withPitch(float pitch) {
        return new AdventureSoundStart(Sound.sound(((Sound)this.wrappedObject).name(), ((Sound)this.wrappedObject).source(), ((Sound)this.wrappedObject).volume(), pitch));
    }

    @Override
    @Nullable
    public Long seed() {
        if (AdventureFeature.SOUND_SEED.isSupported()) {
            OptionalLong seed = ((Sound)this.wrappedObject).seed();
            return seed.isPresent() ? Long.valueOf(seed.getAsLong()) : null;
        }
        return null;
    }

    @Override
    @NotNull
    public SoundStart withSeed(@Nullable Long seed) {
        if (AdventureFeature.SOUND_SEED.isSupported()) {
            return new AdventureSoundStart((Sound)Sound.sound((Sound)this.wrappedObject).seed(seed == null ? OptionalLong.empty() : OptionalLong.of(seed)).build());
        }
        return this;
    }

    @Override
    public @NotNull SoundStart.Builder toBuilder() {
        return new AdventureSoundStartBuilder(this.soundKey(), this.source(), this.volume(), this.pitch(), this.seed());
    }

    public static class AdventureSoundStartBuilder
    implements SoundStart.Builder {
        @NotNull
        private static final SoundSource MASTER = SoundSource.soundSource("master");
        @Nullable
        private ResourceLocation soundKey;
        @NotNull
        private SoundSource source = MASTER;
        private float volume = 1.0f;
        private float pitch = 1.0f;
        @Nullable
        private Long seed;

        @Override
        @NotNull
        public SoundStart.Builder soundKey(@NotNull ResourceLocation key) {
            this.soundKey = "minecraft".equals(key.namespace()) ? ResourceLocation.of("minecraft", AdventureBackend.getSoundKeyNormalizer().apply(key.path())) : key;
            return this;
        }

        @Override
        @NotNull
        public SoundStart.Builder soundKey(@NotNull String key) {
            return this.soundKey(ResourceLocation.of(key));
        }

        @Override
        @NotNull
        public SoundStart build() {
            Preconditions.checkNotNull(this.soundKey, "Sound key must be present!");
            if (AdventureFeature.SOUND_SEED.isSupported()) {
                return new AdventureSoundStart((Sound)Sound.sound().type(Key.key(this.soundKey.namespace(), this.soundKey.path())).source(this.source.as(Sound.Source.class)).volume(this.volume).pitch(this.pitch).seed(this.seed == null ? OptionalLong.empty() : OptionalLong.of(this.seed)).build());
            }
            return new AdventureSoundStart(Sound.sound(Key.key(this.soundKey.namespace(), this.soundKey.path()), this.source.as(Sound.Source.class), this.volume, this.pitch));
        }

        @Generated
        public AdventureSoundStartBuilder() {
        }

        @Generated
        public AdventureSoundStartBuilder(@Nullable ResourceLocation soundKey, @NotNull SoundSource source, float volume, float pitch, @Nullable Long seed) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.soundKey = soundKey;
            this.source = source;
            this.volume = volume;
            this.pitch = pitch;
            this.seed = seed;
        }

        @Override
        @Generated
        public AdventureSoundStartBuilder source(@NotNull SoundSource source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source = source;
            return this;
        }

        @Override
        @Generated
        public AdventureSoundStartBuilder volume(float volume) {
            this.volume = volume;
            return this;
        }

        @Override
        @Generated
        public AdventureSoundStartBuilder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        @Override
        @Generated
        public AdventureSoundStartBuilder seed(@Nullable Long seed) {
            this.seed = seed;
            return this;
        }
    }
}

