/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.block.snapshot;

import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.types.server.BlockSnapshotHolder;
import sba.sl.b.snapshot.BlockSnapshot;
import sba.sl.u.annotations.ProvidedService;

@ProvidedService
public abstract class BlockSnapshots {
    @Nullable
    private static BlockSnapshots blockSnapshots;

    @ApiStatus.Internal
    public BlockSnapshots() {
        if (blockSnapshots != null) {
            throw new UnsupportedOperationException("BlockSnapshots is already initialized.");
        }
        blockSnapshots = this;
    }

    @Contract(value="null -> null")
    @Nullable
    public static <T extends BlockSnapshot> T wrapBlockSnapshot(@Nullable Object blockState) {
        if (blockSnapshots == null) {
            throw new UnsupportedOperationException("BlockSnapshots is not initialized yet.");
        }
        if (blockState == null) {
            return null;
        }
        if (blockState instanceof BlockSnapshot) {
            return (T)((BlockSnapshot)blockState);
        }
        return blockSnapshots.wrapBlockSnapshot0(blockState);
    }

    @Nullable
    protected abstract <T extends BlockSnapshot> T wrapBlockSnapshot0(@Nullable Object var1);

    static {
        BlockSnapshotHolder.Provider.registerProvider(o -> (BlockSnapshotHolder)Objects.requireNonNull(BlockSnapshots.wrapBlockSnapshot(o), "Cannot wrap " + String.valueOf(o) + " to BlockSnapshot"));
    }
}

